/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.cym.model.DenyAllow;
import com.cym.model.Http;
import com.cym.service.HttpService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SnowFlakeUtils;
import java.util.HashMap;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;

@Controller
@Mapping(value="/adminPage/http")
public class HttpController
extends BaseController {
    @Inject
    HttpService httpService;
    @Inject
    SettingService settingService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        List<Http> httpList = this.httpService.findAll();
        modelAndView.put("httpList", httpList);
        modelAndView.put("denyAllowList", this.sqlHelper.findAll(DenyAllow.class));
        modelAndView.view("/adminPage/http/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Http http) {
        if (StrUtil.isEmpty(http.getId())) {
            http.setSeq(SnowFlakeUtils.getId());
        }
        this.sqlHelper.insertOrUpdate(http);
        return this.renderSuccess();
    }

    @Mapping(value="addTemplate")
    public JsonResult addTemplate(String templateId) {
        this.httpService.addTemplate(templateId);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Http.class));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, Http.class);
        return this.renderSuccess();
    }

    @Mapping(value="addGiudeOver")
    public JsonResult addGiudeOver(String json, Boolean logStatus, Boolean webSocket, Boolean mimeTypes) {
        Http http;
        List<Http> https = JSONUtil.toList(JSONUtil.parseArray(json), Http.class);
        if (mimeTypes.booleanValue()) {
            http = new Http();
            http.setName("include");
            http.setValue("mime.types");
            http.setUnit("");
            https.add(http);
            http = new Http();
            http.setName("default_type");
            http.setValue("application/octet-stream");
            http.setUnit("");
            https.add(http);
        }
        if (logStatus.booleanValue()) {
            http = new Http();
            http.setName("access_log");
            http.setValue(this.homeConfig.home + "log/access.log");
            http.setUnit("");
            https.add(http);
            http = new Http();
            http.setName("error_log");
            http.setValue(this.homeConfig.home + "log/error.log");
            http.setUnit("");
            https.add(http);
        }
        if (webSocket.booleanValue()) {
            http = new Http();
            http.setName("map");
            http.setValue("$http_upgrade $connection_upgrade {\r\n    default upgrade;\r\n    '' close;\r\n}\r\n");
            http.setUnit("");
            https.add(http);
        }
        this.httpService.setAll(https);
        return this.renderSuccess();
    }

    @Mapping(value="setOrder")
    public JsonResult setOrder(String id, Integer count) {
        this.httpService.setSeq(id, count);
        return this.renderSuccess();
    }

    @Mapping(value="getDenyAllow")
    public JsonResult getDenyAllow() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("denyAllow", this.settingService.get("denyAllow"));
        map.put("denyId", this.settingService.get("denyId"));
        map.put("allowId", this.settingService.get("allowId"));
        return this.renderSuccess(map);
    }

    @Mapping(value="setDenyAllow")
    public JsonResult setDenyAllow(String denyAllow, String denyId, String allowId) {
        this.settingService.set("denyAllow", denyAllow);
        this.settingService.set("denyId", denyId);
        this.settingService.set("allowId", allowId);
        return this.renderSuccess();
    }

    @Mapping(value="setEnable")
    public JsonResult setEnable(Http http) {
        this.sqlHelper.updateById(http);
        return this.renderSuccess();
    }
}

