/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import com.cym.config.AppFilter;
import com.cym.model.Log;
import com.cym.service.LogService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BLogFileTailer;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import java.io.File;
import java.io.IOException;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/log")
public class LogController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    SettingService settingService;
    @Inject
    LogService logService;
    @Inject
    AppFilter appFilter;
    @Inject
    BLogFileTailer bLogFileTailer;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page) {
        this.setPage(page);
        page = this.logService.search(page);
        modelAndView.put("page", page);
        modelAndView.put("isLinux", SystemTool.isLinux());
        modelAndView.view("/adminPage/log/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Log log) {
        if (this.logService.hasDir(log.getPath(), log.getId())) {
            return this.renderError(this.m.get("logStr.sameDir"));
        }
        if (FileUtil.isDirectory(log.getPath())) {
            return this.renderError(this.m.get("logStr.notFile"));
        }
        this.sqlHelper.insertOrUpdate(log);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Log.class));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, Log.class);
        return this.renderSuccess();
    }

    @Mapping(value="tail")
    public ModelAndView tail(ModelAndView modelAndView, String id, String protocol) {
        modelAndView.put("id", id);
        modelAndView.view("/adminPage/log/tail.html");
        return modelAndView;
    }

    @Mapping(value="down")
    public File down(String id) throws IOException {
        Log log = this.sqlHelper.findById(id, Log.class);
        return new File(log.getPath());
    }

    @Mapping(value="tailCmd")
    public JsonResult tailCmd(String id, String guid) {
        Log log = this.sqlHelper.findById(id, Log.class);
        if (!FileUtil.exist(log.getPath())) {
            return this.renderSuccess("");
        }
        String rs = this.bLogFileTailer.run(guid, log.getPath());
        return this.renderSuccess(rs);
    }
}

