/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.StrUtil;
import com.cym.config.VersionConfig;
import com.cym.config.ViewConfig;
import com.cym.model.Admin;
import com.cym.model.Remote;
import com.cym.service.AdminService;
import com.cym.service.CreditService;
import com.cym.service.SettingService;
import com.cym.utils.AuthUtils;
import com.cym.utils.BaseController;
import com.cym.utils.EncodePassUtils;
import com.cym.utils.JsonResult;
import com.cym.utils.PwdCheckUtil;
import com.cym.utils.SystemTool;
import com.wf.captcha.SpecCaptcha;
import java.util.HashMap;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;

@Mapping(value="/adminPage/login")
@Controller
public class LoginController
extends BaseController {
    @Inject
    AdminService adminService;
    @Inject
    CreditService creditService;
    @Inject
    VersionConfig versionConfig;
    @Inject
    AuthUtils authUtils;
    @Inject
    SettingService settingService;

    @Mapping(value="")
    public ModelAndView admin(ModelAndView modelAndView, String adminId) {
        modelAndView.put("adminCount", this.sqlHelper.findAllCount(Admin.class));
        modelAndView.view("/adminPage/login/index.html");
        return modelAndView;
    }

    @Mapping(value="loginOut")
    public ModelAndView loginOut(ModelAndView modelAndView) {
        Admin admin = (Admin)Context.current().session("admin");
        admin = this.sqlHelper.findById(admin.getId(), Admin.class);
        admin.setAutoKey(null);
        this.sqlHelper.updateAllColumnById(admin);
        Context.current().sessionRemove("isLogin");
        Context.current().sessionRemove("admin");
        modelAndView.view("/adminPage/index.html");
        return modelAndView;
    }

    @Mapping(value="noServer")
    public ModelAndView noServer(ModelAndView modelAndView) {
        modelAndView.view("/adminPage/login/noServer.html");
        return modelAndView;
    }

    private boolean testLenth(String param) {
        return StrUtil.isNotEmpty(param) && param.length() > 1000;
    }

    @Mapping(value="login")
    public JsonResult submitLogin(String name, String pass, String code, String authCode) {
        String captcha;
        if (this.testLenth(name) || this.testLenth(pass) || this.testLenth(code) || this.testLenth(authCode)) {
            return this.renderError(this.m.get("loginStr.backError7"));
        }
        if (StrUtil.isNotEmpty(name)) {
            name = Base64.decodeStr(Base64.decodeStr(name));
        }
        if (StrUtil.isNotEmpty(pass)) {
            pass = Base64.decodeStr(Base64.decodeStr(pass));
        }
        if (StrUtil.isNotEmpty(code)) {
            code = Base64.decodeStr(Base64.decodeStr(code));
        }
        if (StrUtil.isNotEmpty(authCode)) {
            authCode = Base64.decodeStr(Base64.decodeStr(authCode));
        }
        if (!code.equals(captcha = (String)Context.current().session("captcha"))) {
            Context.current().sessionRemove("captcha");
            return this.renderError(this.m.get("loginStr.backError1"));
        }
        Context.current().sessionRemove("captcha");
        Admin admin = this.adminService.login(name, pass);
        if (admin == null) {
            return this.renderError(this.m.get("loginStr.backError2"));
        }
        if (admin.getAuth().booleanValue() && !this.authUtils.testKey(admin.getKey(), authCode).booleanValue()) {
            return this.renderError(this.m.get("loginStr.backError6"));
        }
        admin.setAutoKey(UUID.randomUUID().toString());
        this.sqlHelper.updateById(admin);
        Context.current().sessionSet("localType", "local");
        Context.current().sessionSet("isLogin", true);
        Context.current().sessionSet("admin", admin);
        Context.current().sessionRemove("imgCode");
        this.versionConfig.checkVersion();
        return this.renderSuccess(admin);
    }

    @Mapping(value="autoLogin")
    public JsonResult autoLogin(String autoKey) {
        Admin admin = this.adminService.getByAutoKey(autoKey);
        if (admin != null) {
            Context.current().sessionSet("localType", "local");
            Context.current().sessionSet("isLogin", true);
            Context.current().sessionSet("admin", admin);
            Context.current().sessionRemove("imgCode");
            this.versionConfig.checkVersion();
            return this.renderSuccess(admin);
        }
        return this.renderError();
    }

    @Mapping(value="getAuth")
    public JsonResult getAuth(String name, String pass, String code, Integer remote) {
        String captcha;
        if (this.testLenth(name) || this.testLenth(pass) || this.testLenth(code)) {
            return this.renderError(this.m.get("loginStr.backError7"));
        }
        if (StrUtil.isNotEmpty(name)) {
            name = Base64.decodeStr(Base64.decodeStr(name));
        }
        if (StrUtil.isNotEmpty(pass)) {
            pass = Base64.decodeStr(Base64.decodeStr(pass));
        }
        if (StrUtil.isNotEmpty(code)) {
            code = Base64.decodeStr(Base64.decodeStr(code));
        }
        if (remote == null && !code.equals(captcha = (String)Context.current().session("captcha"))) {
            Context.current().sessionRemove("captcha");
            return this.renderError(this.m.get("loginStr.backError1"));
        }
        Admin admin = this.adminService.login(name, pass);
        if (admin == null) {
            return this.renderError(this.m.get("loginStr.backError2"));
        }
        Admin ad = new Admin();
        ad.setAuth(admin.getAuth());
        ad.setKey(admin.getKey());
        return this.renderSuccess(ad);
    }

    @Mapping(value="getCredit")
    public JsonResult getCredit(String name, String pass, String code, String auth) {
        Admin admin;
        if (this.testLenth(name) || this.testLenth(pass) || this.testLenth(code)) {
            return this.renderError(this.m.get("loginStr.backError7"));
        }
        if (StrUtil.isNotEmpty(name)) {
            name = Base64.decodeStr(Base64.decodeStr(name));
        }
        if (StrUtil.isNotEmpty(pass)) {
            pass = Base64.decodeStr(Base64.decodeStr(pass));
        }
        if (StrUtil.isNotEmpty(code)) {
            code = Base64.decodeStr(Base64.decodeStr(code));
        }
        if ((admin = this.adminService.login(name, pass)) == null) {
            return this.renderError(this.m.get("loginStr.backError2"));
        }
        if (!admin.getAuth().booleanValue()) {
            String imgCode = this.settingService.get("remoteCode");
            if (StrUtil.isEmpty(imgCode) || StrUtil.isNotEmpty(imgCode) && !imgCode.equalsIgnoreCase(code)) {
                return this.renderError(this.m.get("loginStr.backError1"));
            }
        } else if (!this.authUtils.testKey(admin.getKey(), auth).booleanValue()) {
            return this.renderError(this.m.get("loginStr.backError6"));
        }
        this.settingService.remove("remoteCode");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("creditKey", this.creditService.make(admin.getId()));
        map.put("system", SystemTool.getSystem());
        return this.renderSuccess(map);
    }

    @Mapping(value="getLocalType")
    public JsonResult getLocalType() {
        String localType = (String)Context.current().session("localType");
        if (StrUtil.isNotEmpty(localType)) {
            if ("local".equals(localType)) {
                return this.renderSuccess(this.m.get("remoteStr.local"));
            }
            Remote remote = (Remote)Context.current().session("remote");
            if (StrUtil.isNotEmpty(remote.getDescr())) {
                return this.renderSuccess(remote.getDescr());
            }
            return this.renderSuccess(remote.getIp() + ":" + remote.getPort());
        }
        return this.renderSuccess("");
    }

    @Mapping(value="addAdmin")
    public JsonResult addAdmin(String name, String pass) {
        Long adminCount = this.sqlHelper.findAllCount(Admin.class);
        if (adminCount > 0L) {
            return this.renderError(this.m.get("loginStr.backError4"));
        }
        if (!(PwdCheckUtil.checkContainUpperCase(pass) && PwdCheckUtil.checkContainLowerCase(pass) && PwdCheckUtil.checkContainDigit(pass) && PwdCheckUtil.checkPasswordLength(pass, "8", "100"))) {
            return this.renderError(this.m.get("loginStr.tips"));
        }
        Admin admin = new Admin();
        admin.setName(name);
        admin.setPass(EncodePassUtils.encode(pass));
        admin.setAuth(false);
        admin.setType(0);
        this.sqlHelper.insert(admin);
        return this.renderSuccess();
    }

    @Mapping(value="/getCode")
    public void getCode() throws Exception {
        Context.current().headerAdd("Pragma", "No-cache");
        Context.current().headerAdd("Cache-Control", "no-cache");
        Context.current().headerAdd("Expires", "0");
        Context.current().contentType("image/gif");
        SpecCaptcha specCaptcha = new SpecCaptcha(100, 40, 4);
        specCaptcha.setCharType(2);
        Context.current().sessionSet("captcha", specCaptcha.text().toLowerCase());
        specCaptcha.out(Context.current().outputStream());
    }

    @Mapping(value="/getRemoteCode")
    public void getRemoteCode() throws Exception {
        Context.current().headerAdd("Pragma", "No-cache");
        Context.current().headerAdd("Cache-Control", "no-cache");
        Context.current().headerAdd("Expires", "0");
        Context.current().contentType("image/gif");
        SpecCaptcha specCaptcha = new SpecCaptcha(100, 40, 4);
        specCaptcha.setCharType(2);
        this.settingService.set("remoteCode", specCaptcha.text());
        specCaptcha.out(Context.current().outputStream());
    }

    @Mapping(value="/changeLang")
    public JsonResult changeLang(String lang) {
        Long adminCount = this.sqlHelper.findAllCount(Admin.class);
        Boolean isLogin = (Boolean)Context.current().session("isLogin");
        if (adminCount == 0L || isLogin != null && isLogin.booleanValue()) {
            if (lang.equals("zh")) {
                lang = "";
            }
            ViewConfig.lang = lang;
            this.settingService.set("lang", lang);
        }
        return this.renderSuccess();
    }
}

