/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.ext.MonitorInfo;
import com.cym.ext.NetworkInfo;
import com.cym.service.MonitorService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NetWorkUtil;
import com.cym.utils.SystemTool;
import java.util.Date;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapping(value="/adminPage/monitor")
@Controller
public class MonitorController
extends BaseController {
    @Inject
    MonitorService monitorService;
    @Inject
    SettingService settingService;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.put("list", this.monitorService.getDiskInfo());
        String nginxPath = this.settingService.get("nginxPath");
        String nginxExe = this.settingService.get("nginxExe");
        String nginxDir = this.settingService.get("nginxDir");
        modelAndView.put("nginxDir", nginxDir);
        modelAndView.put("nginxExe", nginxExe);
        modelAndView.put("nginxPath", nginxPath);
        boolean isInit = StrUtil.isNotEmpty(nginxExe);
        modelAndView.put("isInit", Boolean.toString(isInit));
        modelAndView.view("/adminPage/monitor/index.html");
        return modelAndView;
    }

    @Mapping(value="load")
    public JsonResult load() {
        MonitorInfo monitorInfo = this.monitorService.getMonitorInfoOshi();
        return this.renderSuccess(monitorInfo);
    }

    @Mapping(value="network")
    public JsonResult network() throws InterruptedException {
        if (SystemTool.isLinux().booleanValue() && !this.hasIfconfig()) {
            Thread.sleep(2000L);
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.setTime(DateUtil.format(new Date(), "HH:mm:ss"));
            networkInfo.setSend(0.0);
            networkInfo.setReceive(0.0);
            return this.renderSuccess(networkInfo);
        }
        NetworkInfo networkInfo = NetWorkUtil.getNetworkDownUp();
        return this.renderSuccess(networkInfo);
    }

    private boolean hasIfconfig() {
        String rs = RuntimeUtil.execForStr("which ifconfig");
        return StrUtil.isNotEmpty(rs);
    }

    @Mapping(value="addNginxGiudeOver")
    public JsonResult addNginxGiudeOver(String nginxDir, String nginxExe) {
        this.settingService.set("nginxDir", nginxDir);
        this.settingService.set("nginxExe", nginxExe);
        return this.renderSuccess();
    }
}

