/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.config.VersionConfig;
import com.cym.controller.adminPage.ConfController;
import com.cym.controller.adminPage.MainController;
import com.cym.controller.api.NginxApiController;
import com.cym.ext.AsycPack;
import com.cym.ext.Tree;
import com.cym.model.Admin;
import com.cym.model.Group;
import com.cym.model.Remote;
import com.cym.service.ConfService;
import com.cym.service.GroupService;
import com.cym.service.RemoteService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NginxUtils;
import com.cym.utils.SystemTool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/remote")
public class RemoteController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    RemoteService remoteService;
    @Inject
    SettingService settingService;
    @Inject
    ConfService confService;
    @Inject
    GroupService groupService;
    @Inject
    ConfController confController;
    @Inject
    MainController mainController;
    @Inject
    NginxApiController nginxApiController;
    @Inject
    VersionConfig versionConfig;
    @Inject(value="${server.port}")
    Integer port;

    @Mapping(value="version")
    public Map<String, Object> version() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.versionConfig.currentVersion);
        if (NginxUtils.isRun()) {
            map.put("nginx", 1);
        } else {
            map.put("nginx", 0);
        }
        return map;
    }

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        JsonResult<List<String>> jsonResult = this.nginxApiController.getNginxStartCmd();
        modelAndView.put("startCmds", jsonResult.getObj());
        jsonResult = this.nginxApiController.getNginxStopCmd();
        modelAndView.put("stopCmds", jsonResult.getObj());
        modelAndView.put("projectVersion", this.versionConfig.currentVersion);
        modelAndView.view("/adminPage/remote/index.html");
        return modelAndView;
    }

    @Mapping(value="allTable")
    public Map<String, Object> allTable(Context context) {
        Admin admin = this.getAdmin();
        List<Remote> remoteList = this.sqlHelper.findAll(Remote.class);
        for (Remote remote : remoteList) {
            Remote remoteSession;
            remote.setStatus(0);
            remote.setType(0);
            if (remote.getParentId() == null) {
                remote.setParentId("");
            }
            remote.setSelect(false);
            if (context.session("localType").equals("remote") && (remoteSession = (Remote)context.session("remote")).getId().equals(remote.getId())) {
                remote.setSelect(true);
            }
            try {
                String json = HttpUtil.get(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/version?creditKey=" + remote.getCreditKey(), 1000);
                if (!StrUtil.isNotEmpty(json)) continue;
                Map map = (Map)JSONUtil.toBean(json, new TypeReference<Map<String, Object>>(){}.getType(), false);
                remote.setStatus(1);
                remote.setVersion((String)map.get("version"));
                remote.setNginx((Integer)map.get("nginx"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        Remote remoteLocal = new Remote();
        remoteLocal.setId("local");
        remoteLocal.setIp("");
        remoteLocal.setProtocol("");
        remoteLocal.setParentId("");
        remoteLocal.setDescr(this.m.get("remoteStr.local"));
        Map<String, Object> map = this.version();
        remoteLocal.setVersion((String)map.get("version"));
        remoteLocal.setNginx((Integer)map.get("nginx"));
        remoteLocal.setPort(this.port);
        remoteLocal.setStatus(1);
        remoteLocal.setType(0);
        remoteLocal.setMonitor(this.settingService.get("monitorLocal") != null ? Integer.parseInt(this.settingService.get("monitorLocal")) : 0);
        remoteLocal.setSystem(SystemTool.getSystem());
        remoteLocal.setSelect(false);
        if (context.session("localType").equals("local")) {
            remoteLocal.setSelect(true);
        }
        remoteList.add(0, remoteLocal);
        List<Group> groupList = this.remoteService.getGroupByAdmin(admin);
        for (Group group : groupList) {
            Remote remoteGroup = new Remote();
            remoteGroup.setDescr(group.getName());
            remoteGroup.setId(group.getId());
            remoteGroup.setParentId(this.checkParent(group.getParentId(), groupList));
            remoteGroup.setType(1);
            remoteGroup.setIp("");
            remoteGroup.setProtocol("");
            remoteGroup.setVersion("");
            remoteGroup.setSystem("");
            remoteList.add(remoteGroup);
        }
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("code", 0);
        mapResult.put("data", remoteList);
        return mapResult;
    }

    private String checkParent(String parentId, List<Group> groupList) {
        if (parentId == null) {
            return "";
        }
        for (Group group : groupList) {
            if (!group.getId().equals(parentId)) continue;
            return parentId;
        }
        return "";
    }

    @Mapping(value="addGroupOver")
    public JsonResult addGroupOver(Group group) {
        if (StrUtil.isNotEmpty(group.getParentId()) && StrUtil.isNotEmpty(group.getId()) && group.getId().equals(group.getParentId())) {
            return this.renderError(this.m.get("remoteStr.parentGroupMsg"));
        }
        this.sqlHelper.insertOrUpdate(group);
        return this.renderSuccess();
    }

    @Mapping(value="groupDetail")
    public JsonResult groupDetail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Group.class));
    }

    @Mapping(value="delGroup")
    public JsonResult delGroup(String id) {
        this.groupService.delete(id);
        return this.renderSuccess();
    }

    @Mapping(value="getGroupTree")
    public JsonResult getGroupTree() {
        Admin admin = this.getAdmin();
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        Tree tree = new Tree();
        tree.setName(this.m.get("remoteStr.noGroup"));
        tree.setValue("");
        treeList.add(0, tree);
        List<Group> groups = this.remoteService.getGroupByAdmin(admin);
        this.fillTree(groups, treeList);
        return this.renderSuccess(treeList);
    }

    public void fillTree(List<Group> groups, List<Tree> treeList) {
        for (Group group : groups) {
            if (this.hasParentIn(group.getParentId(), groups)) continue;
            Tree tree = new Tree();
            tree.setName(group.getName());
            tree.setValue(group.getId());
            ArrayList<Tree> treeSubList = new ArrayList<Tree>();
            this.fillTree(this.groupService.getListByParent(group.getId()), treeSubList);
            tree.setChildren(treeSubList);
            treeList.add(tree);
        }
    }

    private boolean hasParentIn(String parentId, List<Group> groups) {
        for (Group group : groups) {
            if (!group.getId().equals(parentId)) continue;
            return true;
        }
        return false;
    }

    @Mapping(value="getCmdRemote")
    public JsonResult getCmdRemote() {
        Admin admin = this.getAdmin();
        List<Group> groups = this.remoteService.getGroupByAdmin(admin);
        List<Remote> remotes = this.remoteService.getListByParent(null);
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        this.fillTreeRemote(groups, remotes, treeList);
        Tree tree = new Tree();
        tree.setName(this.m.get("remoteStr.local"));
        tree.setValue("local");
        treeList.add(0, tree);
        return this.renderSuccess(treeList);
    }

    private void fillTreeRemote(List<Group> groups, List<Remote> remotes, List<Tree> treeList) {
        Tree tree;
        for (Group group : groups) {
            if (this.hasParentIn(group.getParentId(), groups)) continue;
            tree = new Tree();
            tree.setName(group.getName());
            tree.setValue(group.getId());
            ArrayList<Tree> treeSubList = new ArrayList<Tree>();
            this.fillTreeRemote(this.groupService.getListByParent(group.getId()), this.remoteService.getListByParent(group.getId()), treeSubList);
            tree.setChildren(treeSubList);
            treeList.add(tree);
        }
        for (Remote remote : remotes) {
            tree = new Tree();
            tree.setName(remote.getIp() + "\u3010" + remote.getDescr() + "\u3011");
            tree.setValue(remote.getId());
            treeList.add(tree);
        }
    }

    @Mapping(value="cmdOver")
    public JsonResult cmdOver(String[] remoteId, String cmd, Integer interval) {
        if (remoteId == null || remoteId.length == 0) {
            return this.renderSuccess(this.m.get("remoteStr.noSelect"));
        }
        StringBuilder rs = new StringBuilder();
        for (String id : remoteId) {
            JsonResult jsonResult = null;
            if (id.equals("local")) {
                if (cmd.contentEquals("check")) {
                    jsonResult = this.confController.checkBase();
                }
                if (cmd.contentEquals("reload")) {
                    jsonResult = this.confController.reload(null, null, null);
                }
                if (cmd.contentEquals("replace")) {
                    jsonResult = this.confController.replace(this.confController.getReplaceJson(), null);
                }
                if (cmd.startsWith("startNginx") || cmd.startsWith("stopNginx")) {
                    jsonResult = this.confController.runCmd(cmd.replaceFirst("startNginx ", "").replaceFirst("stopNginx ", ""), null);
                }
                if (cmd.contentEquals("update")) {
                    jsonResult = this.renderError(this.m.get("remoteStr.notAllow"));
                }
                rs.append("<span class='blue'>").append(this.m.get("remoteStr.local")).append("> </span>");
            } else {
                Remote remote = this.sqlHelper.findById(id, Remote.class);
                rs.append("<span class='blue'>").append(remote.getIp()).append(":").append(remote.getPort()).append("> </span>");
                if (cmd.contentEquals("check")) {
                    cmd = "checkBase";
                }
                try {
                    String action = cmd;
                    if (cmd.startsWith("startNginx") || cmd.startsWith("stopNginx")) {
                        action = "runCmd";
                    }
                    String url = remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/conf/" + action + "?creditKey=" + remote.getCreditKey();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (cmd.startsWith("startNginx") || cmd.startsWith("stopNginx")) {
                        map.put("cmd", cmd.replaceFirst("startNginx ", "").replaceFirst("stopNginx ", ""));
                    }
                    String json = HttpUtil.post(url, map);
                    jsonResult = JSONUtil.toBean(json, JsonResult.class);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            if (jsonResult != null) {
                if (jsonResult.isSuccess()) {
                    rs.append(jsonResult.getObj().toString());
                } else {
                    rs.append(jsonResult.getMsg());
                }
            }
            rs.append("<br>");
            if (interval == null) continue;
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return this.renderSuccess(rs.toString());
    }

    @Mapping(value="asyc")
    public JsonResult asyc(String fromId, String[] remoteId, String[] asycData) {
        if (StrUtil.isEmpty(fromId) || remoteId == null || remoteId.length == 0) {
            return this.renderError(this.m.get("remoteStr.noChoice"));
        }
        Remote remoteFrom = this.sqlHelper.findById(fromId, Remote.class);
        String json = remoteFrom == null ? this.getAsycPack(asycData) : HttpUtil.get(remoteFrom.getProtocol() + "://" + remoteFrom.getIp() + ":" + remoteFrom.getPort() + "/adminPage/remote/getAsycPack?creditKey=" + remoteFrom.getCreditKey() + "&asycData=" + StrUtil.join((CharSequence)",", Arrays.asList(asycData)), 1000);
        String adminName = this.getAdmin().getName();
        for (String remoteToId : remoteId) {
            if (remoteToId.equals("local") || remoteToId.equals("\u672c\u5730")) {
                this.setAsycPack(json, adminName);
                continue;
            }
            Remote remoteTo = this.sqlHelper.findById(remoteToId, Remote.class);
            try {
                String version = HttpUtil.get(remoteTo.getProtocol() + "://" + remoteTo.getIp() + ":" + remoteTo.getPort() + "/adminPage/remote/version?creditKey=" + remoteTo.getCreditKey(), 1000);
                if (!StrUtil.isNotEmpty(version)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("json", json);
                HttpUtil.post(remoteTo.getProtocol() + "://" + remoteTo.getIp() + ":" + remoteTo.getPort() + "/adminPage/remote/setAsycPack?creditKey=" + remoteTo.getCreditKey() + "&adminName=" + adminName, map);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return this.renderSuccess();
    }

    @Mapping(value="getAsycPack")
    public String getAsycPack(String[] asycData) {
        AsycPack asycPack = this.confService.getAsycPack(asycData);
        return JSONUtil.toJsonPrettyStr(asycPack);
    }

    @Mapping(value="setAsycPack")
    public JsonResult setAsycPack(String json, String adminName) {
        AsycPack asycPack = JSONUtil.toBean(json, AsycPack.class);
        this.confService.setAsycPack(asycPack);
        return this.renderSuccess();
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Remote remote, String code, String auth) {
        remote.setIp(remote.getIp().trim());
        if (this.remoteService.hasSame(remote)) {
            return this.renderError(this.m.get("remoteStr.sameIp"));
        }
        this.remoteService.getCreditKey(remote, code, auth);
        if (StrUtil.isNotEmpty(remote.getCreditKey())) {
            this.sqlHelper.insertOrUpdate(remote);
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("remoteStr.noAuth"));
    }

    @Mapping(value="getAuth")
    public JsonResult getAuth(Remote remote) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", Base64.encode(Base64.encode(remote.getName())));
            map.put("pass", Base64.encode(Base64.encode(remote.getPass())));
            map.put("remote", 1);
            String rs = HttpUtil.post(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/login/getAuth", map, 3000);
            if (StrUtil.isNotEmpty(rs)) {
                JsonResult jsonResult = JSONUtil.toBean(rs, JsonResult.class);
                if (jsonResult.isSuccess()) {
                    return this.renderSuccess(jsonResult.getObj());
                }
                return this.renderError(jsonResult.getMsg());
            }
            return this.renderError(this.m.get("remoteStr.noAuth"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError(this.m.get("remoteStr.noAuth"));
        }
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Remote.class));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        this.sqlHelper.deleteById(id, Remote.class);
        return this.renderSuccess();
    }

    @Mapping(value="content")
    public JsonResult content(String id) {
        Remote remote = this.sqlHelper.findById(id, Remote.class);
        String rs = HttpUtil.get(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/readContent?creditKey=" + remote.getCreditKey());
        return this.renderSuccess(rs);
    }

    @Mapping(value="readContent")
    public String readContent() {
        String nginxPath = this.settingService.get("nginxPath");
        if (FileUtil.exist(nginxPath)) {
            return FileUtil.readString(nginxPath, StandardCharsets.UTF_8);
        }
        return this.m.get("remoteStr.noFile");
    }

    @Mapping(value="change")
    public JsonResult change(String id, Context context) {
        Remote remote = this.sqlHelper.findById(id, Remote.class);
        if (remote == null) {
            context.sessionSet("localType", "local");
            context.sessionRemove("remote");
        } else {
            context.sessionSet("localType", "remote");
            context.sessionSet("remote", remote);
        }
        return this.renderSuccess();
    }

    @Mapping(value="nginxStatus")
    public JsonResult nginxStatus() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mail", this.settingService.get("mail"));
        String nginxMonitor = this.settingService.get("nginxMonitor");
        map.put("nginxMonitor", nginxMonitor != null ? nginxMonitor : "false");
        return this.renderSuccess(map);
    }

    @Mapping(value="nginxOver")
    public JsonResult nginxOver(String mail, String nginxMonitor) {
        this.settingService.set("mail", mail);
        this.settingService.set("nginxMonitor", nginxMonitor);
        return this.renderSuccess();
    }

    @Mapping(value="setMonitor")
    public JsonResult setMonitor(String id, Integer monitor) {
        if (!"local".equals(id)) {
            Remote remote = new Remote();
            remote.setId(id);
            remote.setMonitor(monitor);
            this.sqlHelper.updateById(remote);
        } else {
            this.settingService.set("monitorLocal", monitor.toString());
        }
        return this.renderSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="/src")
    public void src(String url) throws Exception {
        byte[] buffer = new byte[1024];
        URL downUrl = new URL(url);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(downUrl.openConnection().getInputStream());
            OutputStream os = Context.current().outputStream();
            int i = bis.read(buffer);
            while (i != -1) {
                os.write(buffer, 0, i);
                i = bis.read(buffer);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }
}

