/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.ext.TreeNode;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Mapping;

@Controller
@Mapping(value="/adminPage/root")
public class RootController
extends BaseController {
    @Mapping(value="getList")
    public List<TreeNode> getList(String id) {
        if (StrUtil.isEmpty(id)) {
            id = "/";
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        File[] fileList = null;
        fileList = SystemTool.isWindows() != false && id.equals("/") ? File.listRoots() : new File(id).listFiles();
        for (File temp : fileList) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(temp.getPath());
            if (FileUtil.isDirectory(treeNode.getId())) {
                treeNode.setId(treeNode.getId() + "/");
            }
            if (StrUtil.isNotEmpty(temp.getName())) {
                treeNode.setName(temp.getName());
            } else {
                treeNode.setName(temp.getPath());
            }
            if (temp.isDirectory()) {
                treeNode.setIsParent("true");
            } else {
                treeNode.setIsParent("false");
            }
            list.add(treeNode);
        }
        list.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                if (o1.getIsParent().equals("true") && o2.getIsParent().equals("false")) {
                    return -1;
                }
                if (o1.getIsParent().equals("false") && o2.getIsParent().equals("true")) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return list;
    }

    @Mapping(value="mkdir")
    public JsonResult mkdir(String dir, String name) {
        FileUtil.mkdir(dir + name);
        return this.renderSuccess();
    }
}

