/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.lang.UUID;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.cym.controller.adminPage.RemoteController;
import com.cym.model.Admin;
import com.cym.service.AdminService;
import com.cym.service.GroupService;
import com.cym.service.SettingService;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.utils.AuthUtils;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SendMailUtils;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/sso")
public class SSOController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    AdminService adminService;
    @Inject
    SettingService settingService;
    @Inject
    SendMailUtils sendCloudUtils;
    @Inject
    AuthUtils authUtils;
    @Inject
    GroupService groupService;
    @Inject
    RemoteController remoteController;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.put("codeUrl", this.settingService.get("sso_codeUrl"));
        modelAndView.put("tokenUrl", this.settingService.get("sso_tokenUrl"));
        modelAndView.put("userinfoUrl", this.settingService.get("sso_userinfoUrl"));
        modelAndView.put("jsonpath", this.settingService.get("sso_jsonpath"));
        modelAndView.put("clientID", this.settingService.get("sso_clientID"));
        modelAndView.put("clientSecret", this.settingService.get("sso_clientSecret"));
        modelAndView.view("/adminPage/sso/index.html");
        return modelAndView;
    }

    @Mapping(value="save")
    public JsonResult save(String codeUrl, String tokenUrl, String userinfoUrl, String jsonpath, String clientID, String clientSecret, String callbackUrl) {
        this.settingService.set("sso_codeUrl", codeUrl);
        this.settingService.set("sso_tokenUrl", tokenUrl);
        this.settingService.set("sso_userinfoUrl", userinfoUrl);
        this.settingService.set("sso_jsonpath", jsonpath);
        this.settingService.set("sso_clientID", clientID);
        this.settingService.set("sso_clientSecret", clientSecret);
        this.settingService.set("sso_callbackUrl", callbackUrl);
        return this.renderSuccess();
    }

    @Mapping(value="redirect")
    public void redirect(Context ctx) {
        String codeUrl = this.settingService.get("sso_codeUrl");
        String clientID = this.settingService.get("sso_clientID");
        String callbackUrl = this.settingService.get("sso_callbackUrl");
        String url = codeUrl + "?client_id=" + clientID + "&response_type=code&redirect_uri=" + callbackUrl + "&oauth_timestamp=" + System.currentTimeMillis() + "&state=";
        ctx.redirect(url);
    }

    @Mapping(value="code")
    public void code(String code, Context ctx) {
        String tokenUrl = this.settingService.get("sso_tokenUrl");
        String userinfoUrl = this.settingService.get("sso_userinfoUrl");
        String jsonpath = this.settingService.get("sso_jsonpath");
        String clientID = this.settingService.get("sso_clientID");
        String clientSecret = this.settingService.get("sso_clientSecret");
        String callbackUrl = this.settingService.get("sso_callbackUrl");
        String getTokenUrl = tokenUrl + "?grant_type=authorization_code&oauth_timestamp=" + System.currentTimeMillis() + "&client_id=" + clientID + "&client_secret=" + clientSecret + "&code=" + code + "&redirect_uri=" + callbackUrl;
        String post = HttpUtil.post(getTokenUrl, "");
        JSONObject entries = JSONUtil.parseObj(post);
        String accessToken = entries.getStr("access_token");
        String userInfoUrl = userinfoUrl + "?access_token=" + accessToken;
        String userinfoStr = HttpUtil.get(userInfoUrl);
        String read = (String)JsonPath.read(userinfoStr, jsonpath, new Predicate[0]);
        Admin admin = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Admin::getName, (Object)read), Admin.class);
        admin.setAutoKey(UUID.randomUUID().toString());
        this.sqlHelper.updateById(admin);
        Context.current().sessionSet("localType", "local");
        Context.current().sessionSet("isLogin", true);
        Context.current().sessionSet("admin", admin);
        Context.current().sessionRemove("imgCode");
        ctx.redirect("/adminPage/monitor");
    }
}

