/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.ext.ServerExt;
import com.cym.model.Cert;
import com.cym.model.DenyAllow;
import com.cym.model.Location;
import com.cym.model.Password;
import com.cym.model.Remote;
import com.cym.model.Server;
import com.cym.model.Upstream;
import com.cym.model.Www;
import com.cym.service.ConfService;
import com.cym.service.ParamService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SnowFlakeUtils;
import com.cym.utils.TelnetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="/adminPage/server")
public class ServerController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    ServerService serverService;
    @Inject
    UpstreamService upstreamService;
    @Inject
    ParamService paramService;
    @Inject
    SettingService settingService;
    @Inject
    ConfService confService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView, Page page, String keywords) {
        this.setPage(page);
        page = this.serverService.search(page, keywords);
        ArrayList<ServerExt> exts = new ArrayList<ServerExt>();
        for (Server server : page.getRecords()) {
            ServerExt serverExt = new ServerExt();
            if (server.getEnable() == null) {
                server.setEnable(false);
            }
            if (StrUtil.isNotEmpty(server.getDescr())) {
                server.setDescr(server.getDescr().replace("\n", "<br>").replace(" ", "&nbsp;"));
            }
            serverExt.setServer(server);
            serverExt.setOverflow(false);
            if (server.getProxyType() == 0) {
                serverExt.setLocationStr(this.buildLocationStr(server.getId()));
                if (this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("enable", (Object)1).eq("serverId", (Object)server.getId()), Location.class) > 5L) {
                    serverExt.setOverflow(true);
                }
            } else {
                Upstream upstream = this.sqlHelper.findById(server.getProxyUpstreamId(), Upstream.class);
                serverExt.setLocationStr(this.m.get("serverStr.server") + ": " + (upstream != null ? upstream.getName() : ""));
            }
            serverExt.setHref((server.getSsl() == 1 ? "https" : "http") + "://" + server.getServerName() + ":" + server.getListen());
            exts.add(serverExt);
        }
        page.setRecords(exts);
        modelAndView.put("page", page);
        List<Upstream> upstreamList = this.upstreamService.getListByProxyType(0);
        modelAndView.put("upstreamList", upstreamList);
        List<Upstream> upstreamTcpList = this.upstreamService.getListByProxyType(1);
        modelAndView.put("upstreamTcpList", upstreamTcpList);
        List<Cert> certs = this.sqlHelper.findAll(Cert.class);
        for (Cert cert : certs) {
            if (cert.getType() != 0 && cert.getType() != 2) continue;
            cert.setDomain(cert.getDomain() + "(" + cert.getEncryption() + ")");
        }
        modelAndView.put("certList", certs);
        modelAndView.put("wwwList", this.sqlHelper.findAll(Www.class));
        modelAndView.put("passwordList", this.sqlHelper.findAll(Password.class));
        modelAndView.put("denyAllowList", this.sqlHelper.findAll(DenyAllow.class));
        modelAndView.put("keywords", keywords);
        modelAndView.view("/adminPage/server/index.html");
        return modelAndView;
    }

    private String buildLocationStr(String id) {
        ArrayList<String> str = new ArrayList<String>();
        List<Location> locations = this.serverService.getLocationByServerId(id);
        for (Location location : locations) {
            if (location.getEnable() != 1) continue;
            String descr = this.m.get("commonStr.descr");
            if (StrUtil.isNotEmpty(location.getDescr())) {
                descr = location.getDescr();
            }
            if (location.getType() == 0) {
                str.add("<span class='path'>" + location.getPath() + "</span><a class='descrBtn' href='javascript:editLocationDescr(\"" + location.getId() + "\")'>" + descr + "</a><br><span class='value'>" + location.getValue() + "</span>");
                continue;
            }
            if (location.getType() == 1) {
                str.add("<span class='path'>" + location.getPath() + "</span><a class='descrBtn' href='javascript:editLocationDescr(\"" + location.getId() + "\")'>" + descr + "</a><br><span class='value'>" + location.getRootPath() + "</span>");
                continue;
            }
            if (location.getType() == 2) {
                Upstream upstream = this.sqlHelper.findById(location.getUpstreamId(), Upstream.class);
                if (upstream == null) continue;
                str.add("<span class='path'>" + location.getPath() + "</span><a class='descrBtn' href='javascript:editLocationDescr(\"" + location.getId() + "\")'>" + descr + "</a><br><span class='value'>http://" + upstream.getName() + (location.getUpstreamPath() != null ? location.getUpstreamPath() : "") + "</span>");
                continue;
            }
            if (location.getType() == 4) {
                str.add("<span class='path'>" + location.getPath() + "</span><a class='descrBtn' href='javascript:editLocationDescr(\"" + location.getId() + "\")'>" + descr + "</a><br><span class='value'>" + location.getReturnUrl() + "</span>");
                continue;
            }
            if (location.getType() != 3) continue;
            str.add("<span class='path'>" + location.getPath() + "</span><a class='descrBtn' href='javascript:editLocationDescr(\"" + location.getId() + "\")'>" + descr + "</a>");
        }
        return StrUtil.join((CharSequence)"<br>", str);
    }

    @Mapping(value="addOver")
    public JsonResult addOver(String serverJson, String serverParamJson, String locationJson) {
        Server server = JSONUtil.toBean(serverJson, Server.class);
        List<Location> locations = JSONUtil.toList(JSONUtil.parseArray(locationJson), Location.class);
        if (StrUtil.isEmpty(server.getId())) {
            server.setSeq(SnowFlakeUtils.getId());
        }
        if (server.getProxyType() == 0) {
            this.serverService.addOver(server, serverParamJson, locations);
        } else {
            this.serverService.addOverTcp(server, serverParamJson);
        }
        return this.renderSuccess();
    }

    @Mapping(value="setEnable")
    public JsonResult setEnable(Server server) {
        this.sqlHelper.updateById(server);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        Server server = this.sqlHelper.findById(id, Server.class);
        ServerExt serverExt = new ServerExt();
        serverExt.setServer(server);
        List<Location> list = this.serverService.getLocationByServerId(id);
        for (Location location : list) {
            String json = this.paramService.getJsonByTypeId(location.getId(), "location");
            location.setLocationParamJson(json);
        }
        serverExt.setLocationList(list);
        String json = this.paramService.getJsonByTypeId(server.getId(), "server");
        serverExt.setParamJson(json);
        return this.renderSuccess(serverExt);
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        this.serverService.deleteById(id);
        return this.renderSuccess();
    }

    @Mapping(value="importServer")
    public JsonResult importServer(String nginxPath) {
        if (StrUtil.isEmpty(nginxPath) || !FileUtil.exist(nginxPath)) {
            return this.renderError(this.m.get("serverStr.fileNotExist"));
        }
        try {
            this.serverService.importServer(nginxPath);
            return this.renderSuccess(this.m.get("serverStr.importSuccess"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError(this.m.get("serverStr.importFail"));
        }
    }

    @Mapping(value="testPort")
    public JsonResult testPort() {
        List<Server> servers = this.sqlHelper.findAll(Server.class);
        ArrayList<String> ips = new ArrayList<String>();
        for (Server server : servers) {
            String ip = "";
            String port = "";
            if (server.getListen().contains(":")) {
                String[] strArray = server.getListen().split(":");
                port = strArray[strArray.length - 1];
                ip = server.getListen().replace(":" + port, "");
            } else {
                ip = "127.0.0.1";
                port = server.getListen();
            }
            if (port.contains("-")) {
                port = port.split("-")[0];
            }
            try {
                if (!TelnetUtils.isRunning(ip, Integer.parseInt(port)) || ips.contains(server.getListen())) continue;
                ips.add(server.getListen());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        if (ips.size() == 0) {
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("serverStr.portUserdList") + ": " + StrUtil.join((CharSequence)" , ", ips));
    }

    @Mapping(value="editDescr")
    public JsonResult editDescr(String id, String descr) {
        Server server = new Server();
        server.setId(id);
        server.setDescr(descr);
        this.sqlHelper.updateById(server);
        return this.renderSuccess();
    }

    @Mapping(value="setOrder")
    public JsonResult setOrder(String id, Integer count) {
        this.serverService.setSeq(id, count);
        return this.renderSuccess();
    }

    @Mapping(value="getDescr")
    public JsonResult getDescr(String id) {
        Server server = this.sqlHelper.findById(id, Server.class);
        return this.renderSuccess(server.getDescr());
    }

    @Mapping(value="getLocationDescr")
    public JsonResult getLocationDescr(String id) {
        Location location = this.sqlHelper.findById(id, Location.class);
        return this.renderSuccess(location.getDescr());
    }

    @Mapping(value="setLocationDescr")
    public JsonResult setLocationDescr(String id, String descr) {
        Location location = new Location();
        location.setId(id);
        location.setDescr(descr);
        this.sqlHelper.updateById(location);
        return this.renderSuccess();
    }

    @Mapping(value="upload")
    public JsonResult upload(Context context, UploadedFile file) {
        try {
            File temp = new File(FileUtil.getTmpDir() + File.separator + file.getName().replace("..", ""));
            file.transferTo(temp);
            File dest = new File(this.homeConfig.home + "cert/" + file.getName().replace("..", ""));
            while (FileUtil.exist(dest)) {
                dest = new File(dest.getPath() + "_1");
            }
            FileUtil.move(temp, dest, true);
            String localType = (String)context.session("localType");
            if ("remote".equals(localType)) {
                Remote remote = (Remote)context.session("remote");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("file", temp);
                String rs = HttpUtil.post(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/upload", paramMap);
                JsonResult jsonResult = JSONUtil.toBean(rs, JsonResult.class);
                FileUtil.del(temp);
                return jsonResult;
            }
            return this.renderSuccess(dest.getPath().replace("\\", "/"));
        }
        catch (IOException | IllegalStateException e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError();
        }
    }
}

