/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import com.cym.model.DenyAllow;
import com.cym.model.Stream;
import com.cym.service.SettingService;
import com.cym.service.StreamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SnowFlakeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;

@Controller
@Mapping(value="/adminPage/stream")
public class StreamController
extends BaseController {
    @Inject
    StreamService streamService;
    @Inject
    SettingService settingService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        List<Stream> streamList = this.streamService.findAll();
        modelAndView.put("streamList", streamList);
        modelAndView.put("denyAllowList", this.sqlHelper.findAll(DenyAllow.class));
        modelAndView.view("/adminPage/stream/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Stream stream) {
        if (StrUtil.isEmpty(stream.getId())) {
            stream.setSeq(SnowFlakeUtils.getId());
        }
        this.sqlHelper.insertOrUpdate(stream);
        return this.renderSuccess();
    }

    @Mapping(value="addTemplate")
    public JsonResult addTemplate(String templateId) {
        this.streamService.addTemplate(templateId);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Stream.class));
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, Stream.class);
        return this.renderSuccess();
    }

    @Mapping(value="setOrder")
    public JsonResult setOrder(String id, Integer count) {
        this.streamService.setSeq(id, count);
        return this.renderSuccess();
    }

    @Mapping(value="addGiudeOver")
    public JsonResult addGiudeOver(Boolean logStatus) {
        ArrayList<Stream> streams = new ArrayList<Stream>();
        if (logStatus.booleanValue()) {
            Stream stream = new Stream();
            stream.setName("log_format basic");
            stream.setValue("'$remote_addr [$time_local] $protocol $status $bytes_sent $bytes_received $session_time \"$upstream_addr\" \"$upstream_bytes_sent\" \"$upstream_bytes_received\" \"$upstream_connect_time\"'");
            stream.setSeq(SnowFlakeUtils.getId());
            streams.add(stream);
            stream = new Stream();
            stream.setName("access_log");
            stream.setValue(this.homeConfig.home + "log/stream_access.log basic");
            stream.setSeq(SnowFlakeUtils.getId());
            streams.add(stream);
            stream = new Stream();
            stream.setName("open_log_file_cache");
            stream.setValue("off");
            stream.setSeq(SnowFlakeUtils.getId());
            streams.add(stream);
        }
        this.streamService.setAll(streams);
        return this.renderSuccess();
    }

    @Mapping(value="getDenyAllow")
    public JsonResult getDenyAllow() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("denyAllowStream", this.settingService.get("denyAllowStream"));
        map.put("denyIdStream", this.settingService.get("denyIdStream"));
        map.put("allowIdStream", this.settingService.get("allowIdStream"));
        return this.renderSuccess(map);
    }

    @Mapping(value="setDenyAllow")
    public JsonResult setDenyAllow(String denyAllow, String denyId, String allowId) {
        this.settingService.set("denyAllowStream", denyAllow);
        this.settingService.set("denyIdStream", denyId);
        this.settingService.set("allowIdStream", allowId);
        return this.renderSuccess();
    }
}

