/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.cym.ext.TemplateExt;
import com.cym.model.Param;
import com.cym.model.Template;
import com.cym.service.TemplateService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;

@Controller
@Mapping(value="/adminPage/template")
public class TemplateController
extends BaseController {
    @Inject
    TemplateService templateService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        List<Template> templateList = this.sqlHelper.findAll(Template.class);
        ArrayList<TemplateExt> extList = new ArrayList<TemplateExt>();
        for (Template template : templateList) {
            TemplateExt templateExt = new TemplateExt();
            templateExt.setTemplate(template);
            templateExt.setParamList(this.templateService.getParamList(template.getId()));
            templateExt.setCount(templateExt.getParamList().size());
            extList.add(templateExt);
        }
        modelAndView.put("templateList", extList);
        modelAndView.view("/adminPage/template/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Template template, String paramJson) {
        Long count;
        if (StrUtil.isEmpty(template.getId()) ? (count = this.templateService.getCountByName(template.getName())) > 0L : (count = this.templateService.getCountByNameWithOutId(template.getName(), template.getId())) > 0L) {
            return this.renderError(this.m.get("templateStr.sameName"));
        }
        List<Param> params = JSONUtil.toList(JSONUtil.parseArray(paramJson), Param.class);
        this.templateService.addOver(template, params);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        Template template = this.sqlHelper.findById(id, Template.class);
        TemplateExt templateExt = new TemplateExt();
        templateExt.setTemplate(template);
        templateExt.setParamList(this.templateService.getParamList(template.getId()));
        templateExt.setCount(templateExt.getParamList().size());
        return this.renderSuccess(templateExt);
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        this.templateService.del(id);
        return this.renderSuccess();
    }

    @Mapping(value="getTemplate")
    public JsonResult getTemplate() {
        return this.renderSuccess(this.sqlHelper.findAll(Template.class));
    }
}

