/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.model.Www;
import com.cym.service.WwwService;
import com.cym.sqlhelper.bean.Sort;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapping(value="/adminPage/www")
@Controller
public class WwwController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    WwwService wwwService;

    @Mapping(value="")
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.put("list", this.sqlHelper.findAll(new Sort("dir", Sort.Direction.ASC), Www.class));
        modelAndView.view("/adminPage/www/index.html");
        return modelAndView;
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Www www, String dirTemp) {
        if (this.wwwService.hasDir(www.getDir(), www.getId()).booleanValue()) {
            return this.renderError(this.m.get("wwwStr.sameDir"));
        }
        try {
            block8: {
                try {
                    if (!this.checkZipSafe(dirTemp, www.getDir(), CharsetUtil.defaultCharset())) {
                        return this.renderError(this.m.get("wwwStr.zipNotSafe"));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.checkZipSafe(dirTemp, www.getDir(), Charset.forName("GBK"))) break block8;
                    return this.renderError(this.m.get("wwwStr.zipNotSafe"));
                }
            }
            try {
                ZipUtil.unzip(dirTemp, www.getDir());
            }
            catch (IllegalArgumentException e) {
                ZipUtil.unzip(dirTemp, www.getDir(), Charset.forName("GBK"));
            }
            FileUtil.del(dirTemp);
            this.sqlHelper.insertOrUpdate(www);
            return this.renderSuccess();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return this.renderError(this.m.get("wwwStr.zipError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkZipSafe(String dirTemp, String dir, Charset charset) {
        File zipFile = new File(dirTemp);
        File outputFolder = new File(dir);
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), charset);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (name.contains("..") || name.startsWith("/") || name.startsWith("\\")) {
                    boolean bl = false;
                    return bl;
                }
                File file = new File(outputFolder, name);
                if (file.getCanonicalPath().startsWith(outputFolder.getCanonicalPath())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return true;
    }

    @Mapping(value="clean")
    public JsonResult clean(String id) {
        Www www = this.sqlHelper.findById(id, Www.class);
        FileUtil.clean(www.getDir());
        return this.renderSuccess();
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        String[] ids = id.split(",");
        this.sqlHelper.deleteByIds(ids, Www.class);
        return this.renderSuccess();
    }

    @Mapping(value="detail")
    public JsonResult detail(String id) {
        Www www = this.sqlHelper.findById(id, Www.class);
        return this.renderSuccess(www);
    }

    public String getClassPath() {
        try {
            String strClassName = this.getClass().getName();
            String strPackageName = "";
            if (this.getClass().getPackage() != null) {
                strPackageName = this.getClass().getPackage().getName();
            }
            String strClassFileName = "";
            strClassFileName = StrUtil.isNotBlank(strPackageName) ? strClassName.substring(strPackageName.length() + 1, strClassName.length()) : strClassName;
            URL url = null;
            url = this.getClass().getResource(strClassFileName + ".class");
            String strURL = url.toString();
            strURL = strURL.substring(strURL.indexOf(47) + 1, strURL.lastIndexOf(47));
            return strURL.replaceAll("%20", " ");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw e;
        }
    }

    @Mapping(value="getDescr")
    public JsonResult getDescr(String id) {
        Www www = this.sqlHelper.findById(id, Www.class);
        return this.renderSuccess(www.getDescr());
    }

    @Mapping(value="editDescr")
    public JsonResult editDescr(String id, String descr) {
        Www www = new Www();
        www.setId(id);
        www.setDescr(descr);
        this.sqlHelper.updateById(www);
        return this.renderSuccess();
    }
}

