/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.api;

import cn.hutool.core.util.StrUtil;
import com.cym.controller.adminPage.CertController;
import com.cym.model.Cert;
import com.cym.model.CertCode;
import com.cym.service.CertService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.io.IOException;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;
import org.noear.solon.core.handle.DownloadedFile;

@Mapping(value="/api/cert")
@Controller
public class CertApiController
extends BaseController {
    @Inject
    CertController certController;
    @Inject
    CertService certService;

    @Mapping(value="getPage")
    public JsonResult<Page<Cert>> getPage(@Param(defaultValue="1") Integer current, @Param(defaultValue="10") Integer limit, String keywords) {
        Page page = new Page();
        page.setCurr(current);
        page.setLimit(limit);
        page = this.certService.getPage(keywords, page);
        for (Cert cert : page.getRecords()) {
            if (cert.getMakeTime() == null || cert.getType() == 1) continue;
            cert.setEndTime(cert.getMakeTime() + 7776000000L);
        }
        return this.renderSuccess(page);
    }

    @Mapping(value="addOver")
    public JsonResult addOver(Cert cert) {
        if (StrUtil.isEmpty(cert.getDomain())) {
            return this.renderError("\u57df\u540d\u4e3a\u7a7a");
        }
        if (cert.getType() == 0 && StrUtil.isEmpty(cert.getDnsType())) {
            return this.renderError("dns\u63d0\u4f9b\u5546\u4e3a\u7a7a");
        }
        return this.certController.addOver(cert, null, null, null);
    }

    @Mapping(value="getTxtValue")
    public JsonResult getTxtValue(String certId) {
        Cert cert = this.sqlHelper.findById(certId, Cert.class);
        if (cert == null) {
            this.renderError("\u8bc1\u4e66\u4e0d\u5b58\u5728");
        }
        JsonResult jsonResult = this.certController.getTxtValue(certId);
        return this.renderSuccess(jsonResult);
    }

    @Mapping(value="setAutoRenew")
    public JsonResult setAutoRenew(String id, Integer autoRenew) {
        Cert cert = new Cert();
        cert.setId(id);
        cert.setAutoRenew(autoRenew);
        this.certController.setAutoRenew(cert);
        return this.renderSuccess();
    }

    @Mapping(value="del")
    public JsonResult del(String id) {
        return this.certController.del(id);
    }

    @Mapping(value="apply")
    public JsonResult<List<CertCode>> apply(String id, String type) {
        JsonResult jsonResult = this.certController.apply(id, type);
        if (jsonResult.isSuccess() && jsonResult.getObj() != null) {
            jsonResult.setMsg(this.m.get("certStr.dnsDescr"));
        }
        return jsonResult;
    }

    @Mapping(value="download")
    public DownloadedFile download(String id) throws IOException {
        return this.certController.download(id);
    }
}

