/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.api;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import com.cym.controller.adminPage.ConfController;
import com.cym.service.AdminService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NginxUtils;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;

@Mapping(value="/api/nginx")
@Controller
public class NginxApiController
extends BaseController {
    @Inject
    ConfController confController;
    @Inject
    AdminService adminService;
    @Inject
    SettingService settingService;

    @Mapping(value="nginxStatus")
    public JsonResult<?> nginxStatus() {
        if (NginxUtils.isRun()) {
            return this.renderSuccess(this.m.get("confStr.running"));
        }
        return this.renderError(this.m.get("confStr.stopped"));
    }

    @Mapping(value="replace")
    public JsonResult<?> replace() {
        JsonResult jsonResult = this.confController.replace(this.confController.getReplaceJson(), null);
        if (jsonResult.isSuccess()) {
            return this.renderSuccess("\u66ff\u6362\u6210\u529f");
        }
        return this.renderError("\u66ff\u6362\u5931\u8d25");
    }

    @Mapping(value="check")
    public JsonResult<?> checkBase() {
        JsonResult jsonResult = this.confController.checkBase();
        if (jsonResult.isSuccess()) {
            return this.renderSuccess("\u6548\u9a8c\u6210\u529f");
        }
        return this.renderError("\u6548\u9a8c\u5931\u8d25");
    }

    @Mapping(value="reload")
    public synchronized JsonResult<?> reload() {
        JsonResult jsonResult = this.confController.reload(null, null, null);
        if (jsonResult.isSuccess()) {
            return this.renderSuccess("\u91cd\u8f7d\u6210\u529f");
        }
        return this.renderError("\u91cd\u8f7d\u5931\u8d25");
    }

    @Mapping(value="getNginxStartCmd")
    public JsonResult<List<String>> getNginxStartCmd() {
        String nginxExe = StrUtil.nullToEmpty(this.settingService.get("nginxExe"));
        String nginxPath = StrUtil.nullToEmpty(this.settingService.get("nginxPath"));
        String nginxDir = StrUtil.nullToEmpty(this.settingService.get("nginxDir"));
        if (StrUtil.isNotEmpty(nginxDir)) {
            nginxDir = " -p " + nginxDir;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(nginxExe + " -c " + nginxPath + nginxDir);
        list.add("systemctl start nginx");
        list.add("service nginx start");
        return this.renderSuccess(list);
    }

    @Mapping(value="getNginxStopCmd")
    public JsonResult<List<String>> getNginxStopCmd() {
        String nginxExe = StrUtil.nullToEmpty(this.settingService.get("nginxExe"));
        String nginxDir = StrUtil.nullToEmpty(this.settingService.get("nginxDir"));
        if (StrUtil.isNotEmpty(nginxDir)) {
            nginxDir = " -p " + nginxDir;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(nginxExe + "  -s stop " + nginxDir);
        list.add("pkill nginx");
        list.add("taskkill /f /im nginx.exe");
        list.add("systemctl stop nginx");
        list.add("service nginx stop");
        return this.renderSuccess(list);
    }

    @Mapping(value="runNginxCmd")
    public JsonResult<?> runNginxCmd(String cmd) {
        JsonResult jsonResult = this.confController.runCmd(cmd, null);
        jsonResult.setObj(HtmlUtil.cleanHtmlTag(jsonResult.getObj().toString()));
        return jsonResult;
    }
}

