/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.api;

import cn.hutool.core.util.StrUtil;
import com.cym.model.Param;
import com.cym.service.ParamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;

@Mapping(value="/api/param")
@Controller
public class ParamApiController
extends BaseController {
    @Inject
    ParamService paramService;

    @Mapping(value="getList")
    public JsonResult<List<Param>> getList(String serverId, String locationId, String upstreamId) {
        if (StrUtil.isEmpty(serverId) && StrUtil.isEmpty(locationId) && StrUtil.isEmpty(upstreamId)) {
            return this.renderError(this.m.get("apiStr.paramError"));
        }
        List<Param> list = this.paramService.getList(serverId, locationId, upstreamId);
        return this.renderSuccess(list);
    }

    @Mapping(value="insertOrUpdate")
    public JsonResult<?> insertOrUpdate(Param param) {
        int count = 0;
        if (StrUtil.isNotEmpty(param.getLocationId())) {
            ++count;
        }
        if (StrUtil.isNotEmpty(param.getServerId())) {
            ++count;
        }
        if (StrUtil.isNotEmpty(param.getUpstreamId())) {
            ++count;
        }
        if (count != 1) {
            return this.renderError(this.m.get("apiStr.paramError"));
        }
        this.sqlHelper.insertOrUpdate(param);
        return this.renderSuccess(param);
    }

    @Mapping(value="del")
    public JsonResult<?> del(String id) {
        this.sqlHelper.deleteById(id, Param.class);
        return this.renderSuccess();
    }
}

