/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.api;

import cn.hutool.core.util.StrUtil;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.UpstreamService;
import com.cym.sqlhelper.bean.Page;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SnowFlakeUtils;
import java.util.List;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;

@Mapping(value="/api/upstream")
@Controller
public class UpstreamApiController
extends BaseController {
    @Inject
    UpstreamService upstreamService;

    @Mapping(value="getPage")
    public JsonResult<Page<Upstream>> getPage(@Param(defaultValue="1") Integer current, @Param(defaultValue="10") Integer limit, String keywords) {
        Page page = new Page();
        page.setCurr(current);
        page.setLimit(limit);
        page = this.upstreamService.search(page, keywords);
        return this.renderSuccess(page);
    }

    @Mapping(value="insertOrUpdate")
    public JsonResult<?> insertOrUpdate(Upstream upstream) {
        Long count;
        if (StrUtil.isEmpty(upstream.getName())) {
            return this.renderError("name" + this.m.get("apiStr.notFill"));
        }
        if (StrUtil.isEmpty(upstream.getId()) ? (count = this.upstreamService.getCountByName(upstream.getName())) > 0L : (count = this.upstreamService.getCountByNameWithOutId(upstream.getName(), upstream.getId())) > 0L) {
            return this.renderError(this.m.get("upstreamStr.sameName"));
        }
        if (StrUtil.isEmpty(upstream.getId())) {
            upstream.setSeq(SnowFlakeUtils.getId());
        }
        this.sqlHelper.insertOrUpdate(upstream);
        return this.renderSuccess(upstream);
    }

    @Mapping(value="delete")
    public JsonResult<?> delete(String id) {
        this.upstreamService.deleteById(id);
        return this.renderSuccess();
    }

    @Mapping(value="getServerByUpstreamId")
    public JsonResult<List<UpstreamServer>> getServerByUpstreamId(String upstreamId) {
        List<UpstreamServer> list = this.upstreamService.getUpstreamServers(upstreamId);
        return this.renderSuccess(list);
    }

    @Mapping(value="insertOrUpdateServer")
    public JsonResult insertOrUpdateServer(UpstreamServer upstreamServer) {
        if (StrUtil.isEmpty(upstreamServer.getUpstreamId())) {
            return this.renderError("upstreamId" + this.m.get("apiStr.notFill"));
        }
        if (null == upstreamServer.getPort()) {
            return this.renderError("port" + this.m.get("apiStr.notFill"));
        }
        if (StrUtil.isEmpty(upstreamServer.getServer())) {
            return this.renderError("server" + this.m.get("apiStr.notFill"));
        }
        this.sqlHelper.insertOrUpdate(upstreamServer);
        return this.renderSuccess(upstreamServer);
    }
}

