/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.util.StrUtil;
import com.cym.model.Admin;
import com.cym.model.AdminGroup;
import com.cym.model.Credit;
import com.cym.sqlhelper.bean.BaseModel;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.ConditionWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.AuthUtils;
import com.cym.utils.EncodePassUtils;
import java.util.List;
import java.util.UUID;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class AdminService {
    @Inject
    SqlHelper sqlHelper;
    @Inject
    AuthUtils authUtils;

    public Admin login(String name, String pass) {
        Admin admin = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Admin::getName, (Object)name).eq(Admin::getPass, (Object)EncodePassUtils.encode(pass)), Admin.class);
        return admin;
    }

    public Admin getByAutoKey(String autoKey) {
        return this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Admin::getAutoKey, (Object)autoKey), Admin.class);
    }

    public Page search(Page page) {
        page = this.sqlHelper.findPage(page, Admin.class);
        return page;
    }

    public Long getCountByName(String name) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq(Admin::getName, (Object)name), Admin.class);
    }

    public Long getCountByNameWithOutId(String name, String id) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq(Admin::getName, (Object)name).ne(BaseModel::getId, (Object)id), Admin.class);
    }

    public Admin getOneByName(String name) {
        return this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Admin::getName, (Object)name), Admin.class);
    }

    public Admin makeToken(String id) {
        String token = UUID.randomUUID().toString();
        Admin admin = new Admin();
        admin.setId(id);
        admin.setToken(token);
        admin.setTokenTimeout(System.currentTimeMillis() + 86400000L);
        this.sqlHelper.updateById(admin);
        return admin;
    }

    public Admin getByToken(String token) {
        Long time = System.currentTimeMillis();
        return this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Admin::getToken, (Object)token).gt(Admin::getTokenTimeout, (Object)time), Admin.class);
    }

    public Admin getByCreditKey(String creditKey) {
        Credit credit = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq(Credit::getKey, (Object)creditKey), Credit.class);
        if (credit != null) {
            Admin admin = this.sqlHelper.findById(credit.getAdminId(), Admin.class);
            return admin;
        }
        return null;
    }

    public List<String> getGroupIds(String adminId) {
        return this.sqlHelper.findPropertiesByQuery((ConditionWrapper)new ConditionAndWrapper().eq(AdminGroup::getAdminId, (Object)adminId), AdminGroup.class, AdminGroup::getGroupId);
    }

    public void addOver(Admin admin, String[] groupIds) {
        this.sqlHelper.insertOrUpdate(admin);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq(AdminGroup::getAdminId, (Object)admin.getId()), AdminGroup.class);
        if (admin.getType() == 1 && groupIds != null) {
            for (String id : groupIds) {
                AdminGroup adminGroup = new AdminGroup();
                adminGroup.setAdminId(admin.getId());
                adminGroup.setGroupId(id);
                this.sqlHelper.insert(adminGroup);
            }
        }
    }

    public void changePassOver(Admin admin) {
        if (admin.getAuth().booleanValue()) {
            Admin adminOrg = this.sqlHelper.findById(admin.getId(), Admin.class);
            if (StrUtil.isEmpty(adminOrg.getKey())) {
                admin.setKey(this.authUtils.makeKey());
            }
        } else {
            admin.setKey("");
        }
        if (StrUtil.isNotEmpty(admin.getPass())) {
            admin.setPass(EncodePassUtils.encode(admin.getPass()));
        } else {
            admin.setPass(null);
        }
        this.sqlHelper.updateById(admin);
    }
}

