/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.config.HomeConfig;
import com.cym.model.Cert;
import com.cym.model.CertCode;
import com.cym.sqlhelper.bean.BaseModel;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.io.File;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class CertService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    SqlHelper sqlHelper;
    @Inject
    HomeConfig homeConfig;

    public boolean hasSame(Cert cert) {
        return StrUtil.isEmpty(cert.getId()) ? this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("domain", (Object)cert.getDomain()), Cert.class) > 0L : this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("domain", (Object)cert.getDomain()).ne("id", (Object)cert.getId()), Cert.class) > 0L;
    }

    public List<CertCode> getCertCodes(String certId) {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(CertCode::getCertId, (Object)certId), CertCode.class);
    }

    public void insertOrUpdate(Cert cert, String[] domain, String[] type, String[] value) {
        this.sqlHelper.insertOrUpdate(cert);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq(CertCode::getCertId, (Object)cert.getId()), CertCode.class);
        if (domain != null && type != null && value != null) {
            for (int i = 0; i < domain.length; ++i) {
                CertCode certCode = new CertCode();
                certCode.setCertId(cert.getId());
                certCode.setDomain(domain[i]);
                certCode.setType(type[i]);
                certCode.setValue(value[i]);
                this.sqlHelper.insert(certCode);
            }
        }
    }

    public List<Cert> findAll() {
        return this.sqlHelper.findAll(new Sort(BaseModel::getId, Sort.Direction.ASC), Cert.class);
    }

    public Page getPage(String keywords, Page page) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isNotEmpty(keywords)) {
            conditionAndWrapper.like(Cert::getDomain, keywords);
        }
        return this.sqlHelper.findPage(conditionAndWrapper, page, Cert.class);
    }

    public void saveCertCode(String certId, List<CertCode> mapList) {
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq(CertCode::getCertId, (Object)certId), CertCode.class);
        for (CertCode certCode : mapList) {
            certCode.setCertId(certId);
            this.sqlHelper.insert(certCode);
        }
    }

    public boolean hasCode(String certId) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq(CertCode::getCertId, (Object)certId), CertCode.class) > 0L;
    }

    public String getAcmeZipBase64() {
        try {
            File file = ZipUtil.zip(this.homeConfig.home + ".acme.sh", this.homeConfig.home + "temp" + File.separator + "acme.zip");
            String str = Base64.encode(file);
            file.delete();
            return str;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public String getCertZipBase64() {
        try {
            File file = ZipUtil.zip(this.homeConfig.home + "cert", this.homeConfig.home + "temp" + File.separator + "cert.zip");
            String str = Base64.encode(file);
            file.delete();
            return str;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public void writeAcmeZipBase64(String acmeZip) {
        if (StrUtil.isNotEmpty(acmeZip)) {
            Base64.decodeToFile(acmeZip, new File(this.homeConfig.home + "temp" + File.separator + "acme.zip"));
            FileUtil.del(this.homeConfig.home + ".acme.sh/");
            FileUtil.mkdir(this.homeConfig.home + ".acme.sh/");
            ZipUtil.unzip(this.homeConfig.home + "temp" + File.separator + "acme.zip", this.homeConfig.home + ".acme.sh/");
            FileUtil.del(this.homeConfig.home + "temp" + File.separator + "acme.zip");
        }
    }

    public void writeCertZipBase64(String certZip) {
        if (StrUtil.isNotEmpty(certZip)) {
            Base64.decodeToFile(certZip, new File(this.homeConfig.home + "temp" + File.separator + "cert.zip"));
            FileUtil.del(this.homeConfig.home + "cert/");
            FileUtil.mkdir(this.homeConfig.home + "cert/");
            ZipUtil.unzip(this.homeConfig.home + "temp" + File.separator + "cert.zip", this.homeConfig.home + "cert/");
            FileUtil.del(this.homeConfig.home + "temp" + File.separator + "cert.zip");
        }
    }

    public boolean hasName(Cert cert) {
        Long count;
        return StrUtil.isEmpty(cert.getId()) ? (count = this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq(Cert::getDomain, (Object)cert.getDomain()), Cert.class)) > 0L : (count = this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq(Cert::getDomain, (Object)cert.getDomain()).ne(BaseModel::getId, (Object)cert.getId()), Cert.class)) > 0L;
    }
}

