/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.config.HomeConfig;
import com.cym.ext.AsycPack;
import com.cym.ext.ConfExt;
import com.cym.ext.ConfFile;
import com.cym.model.Bak;
import com.cym.model.BakSub;
import com.cym.model.Basic;
import com.cym.model.Cert;
import com.cym.model.CertCode;
import com.cym.model.DenyAllow;
import com.cym.model.Http;
import com.cym.model.Location;
import com.cym.model.Param;
import com.cym.model.Password;
import com.cym.model.Server;
import com.cym.model.Stream;
import com.cym.model.Template;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.CertService;
import com.cym.service.DenyAllowService;
import com.cym.service.LocationService;
import com.cym.service.OperateLogService;
import com.cym.service.ParamService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.TemplateService;
import com.cym.service.UpstreamService;
import com.cym.sqlhelper.bean.BaseModel;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.SystemTool;
import com.cym.utils.ToolUtils;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxDumper;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ConfService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    UpstreamService upstreamService;
    @Inject
    SettingService settingService;
    @Inject
    ServerService serverService;
    @Inject
    LocationService locationService;
    @Inject
    ParamService paramService;
    @Inject
    SqlHelper sqlHelper;
    @Inject
    TemplateService templateService;
    @Inject
    OperateLogService operateLogService;
    @Inject
    HomeConfig homeConfig;
    @Inject
    CertService certService;
    @Inject
    DenyAllowService denyAllowService;

    public synchronized ConfExt buildConf(Boolean decompose, Boolean check) {
        ConfExt confExt = new ConfExt();
        confExt.setFileList(new ArrayList<ConfFile>());
        try {
            String filename;
            NgxParam ngxParam;
            NgxConfig ngxConfig = new NgxConfig();
            List<Basic> basicList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Basic.class);
            for (Basic basic : basicList) {
                NgxParam ngxParam2 = new NgxParam();
                ngxParam2.addValue(basic.getName().trim() + " " + basic.getValue().trim());
                ngxConfig.addEntry(ngxParam2);
            }
            List<Http> httpList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Http.class);
            boolean hasHttp = false;
            NgxBlock ngxBlockHttp = new NgxBlock();
            ngxBlockHttp.addValue("http");
            for (Http http : httpList) {
                if (http.getEnable() == null || !http.getEnable().booleanValue()) continue;
                NgxParam ngxParam3 = new NgxParam();
                ngxParam3.addValue(http.getName().trim() + " " + http.getValue().trim());
                ngxBlockHttp.addEntry(ngxParam3);
                hasHttp = true;
            }
            this.buildDenyAllow(ngxBlockHttp, "http", "http", confExt);
            List<Upstream> upstreams = this.upstreamService.getListByProxyType(0);
            for (Upstream upstream : upstreams) {
                NgxBlock ngxBlockServer = new NgxBlock();
                ngxBlockServer.addValue("upstream " + upstream.getName().trim());
                if (StrUtil.isNotEmpty(upstream.getDescr())) {
                    String[] descrs = upstream.getDescr().split("\n");
                    for (String d : descrs) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("# " + (String)d);
                        ngxBlockServer.addEntry(ngxParam);
                    }
                }
                if (StrUtil.isNotEmpty(upstream.getTactics())) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue(upstream.getTactics());
                    ngxBlockServer.addEntry(ngxParam);
                }
                List<UpstreamServer> upstreamServers = this.upstreamService.getUpstreamServers(upstream.getId());
                for (UpstreamServer upstreamServer : upstreamServers) {
                    if (upstreamServer.getEnable() != 1) continue;
                    ngxParam = new NgxParam();
                    ngxParam.addValue("server " + this.buildNodeStr(upstreamServer));
                    ngxBlockServer.addEntry(ngxParam);
                }
                List<Param> paramList = this.paramService.getListByTypeId(upstream.getId(), "upstream");
                for (Param param : paramList) {
                    this.setSameParam(param, ngxBlockServer);
                }
                hasHttp = true;
                if (decompose.booleanValue()) {
                    filename = this.addConfFile(confExt, "upstreams." + upstream.getName() + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + filename);
                    ngxBlockHttp.addEntry(ngxParam);
                    continue;
                }
                ngxBlockHttp.addEntry(ngxBlockServer);
            }
            List<Server> servers = this.serverService.getListByProxyType(new String[]{"0"});
            for (Server server : servers) {
                if (server.getEnable() == null || !server.getEnable().booleanValue()) continue;
                NgxBlock ngxBlockServer = this.bulidBlockServer(server, confExt);
                hasHttp = true;
                if (decompose.booleanValue()) {
                    Iterator<BaseModel> name = "all";
                    if (StrUtil.isNotEmpty(server.getServerName())) {
                        name = server.getServerName();
                    }
                    filename = this.addConfFile(confExt, (String)((Object)name) + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + filename);
                    if (!this.noContain(ngxBlockHttp, ngxParam)) continue;
                    ngxBlockHttp.addEntry(ngxParam);
                    continue;
                }
                ngxBlockHttp.addEntry(ngxBlockServer);
            }
            if (hasHttp) {
                ngxConfig.addEntry(ngxBlockHttp);
            }
            List<Stream> list = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Stream.class);
            boolean hasStream = false;
            NgxBlock ngxBlockStream = new NgxBlock();
            ngxBlockStream.addValue("stream");
            for (Stream stream : list) {
                ngxParam = new NgxParam();
                ngxParam.addValue(stream.getName() + " " + stream.getValue());
                ngxBlockStream.addEntry(ngxParam);
                hasStream = true;
            }
            this.buildDenyAllow(ngxBlockStream, "stream", "stream", confExt);
            upstreams = this.upstreamService.getListByProxyType(1);
            for (Upstream upstream : upstreams) {
                NgxBlock ngxBlockServer = this.buildBlockUpstream(upstream);
                if (decompose.booleanValue()) {
                    String filename2 = this.addConfFile(confExt, "upstreams." + upstream.getName() + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + filename2);
                    ngxBlockStream.addEntry(ngxParam);
                } else {
                    ngxBlockStream.addEntry(ngxBlockServer);
                }
                hasStream = true;
            }
            servers = this.serverService.getListByProxyType(new String[]{"1", "2"});
            for (Server server : servers) {
                if (server.getEnable() == null || !server.getEnable().booleanValue()) continue;
                NgxBlock ngxBlockServer = this.bulidBlockServer(server, confExt);
                if (decompose.booleanValue()) {
                    String type = "";
                    if (server.getProxyType() == 0) {
                        type = "http";
                    } else if (server.getProxyType() == 1) {
                        type = "tcp";
                    } else if (server.getProxyType() == 2) {
                        type = "udp";
                    }
                    String filename3 = this.addConfFile(confExt, type + "." + server.getListen() + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + filename3);
                    ngxBlockStream.addEntry(ngxParam);
                } else {
                    ngxBlockStream.addEntry(ngxBlockServer);
                }
                hasStream = true;
            }
            if (hasStream) {
                ngxConfig.addEntry(ngxBlockStream);
            }
            String conf = ToolUtils.handleConf(new NgxDumper(ngxConfig).dump());
            while (conf.contains(";;")) {
                conf = conf.replaceAll(";;", ";");
            }
            confExt.setConf(conf);
            Collections.sort(confExt.getFileList(), new Comparator<ConfFile>(){

                @Override
                public int compare(ConfFile o1, ConfFile o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return confExt;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public void buildDenyAllow(NgxBlock ngxBlock, String type, String id, ConfExt confExt) {
        String[] ips;
        DenyAllow denyAllow;
        Integer denyAllowValue = null;
        String denyId = null;
        String allowId = null;
        if (type.equals("http")) {
            denyAllowValue = Integer.parseInt(this.settingService.get("denyAllow"));
            denyId = this.settingService.get("denyId");
            allowId = this.settingService.get("allowId");
        } else if (type.equals("stream")) {
            denyAllowValue = Integer.parseInt(this.settingService.get("denyAllowStream"));
            denyId = this.settingService.get("denyIdStream");
            allowId = this.settingService.get("allowIdStream");
        } else if (type.equals("server")) {
            Server server = this.sqlHelper.findById(id, Server.class);
            denyAllowValue = server.getDenyAllow();
            denyId = server.getDenyId();
            allowId = server.getAllowId();
        }
        ArrayList<String> strs = new ArrayList<String>();
        if (denyAllowValue == 1) {
            denyAllow = this.sqlHelper.findById(denyId, DenyAllow.class);
            if (denyAllow != null) {
                for (String ip : ips = denyAllow.getIp().split("\n")) {
                    strs.add("deny " + ip.trim() + ";");
                }
            }
            strs.add("allow all;");
        }
        if (denyAllowValue == 2) {
            denyAllow = this.sqlHelper.findById(allowId, DenyAllow.class);
            if (denyAllow != null) {
                for (String ip : ips = denyAllow.getIp().split("\n")) {
                    strs.add("allow " + ip.trim() + ";");
                }
            }
            strs.add("deny all;");
        }
        if (denyAllowValue == 3) {
            denyAllow = this.sqlHelper.findById(allowId, DenyAllow.class);
            if (denyAllow != null) {
                for (String ip : ips = denyAllow.getIp().split("\n")) {
                    strs.add("allow " + ip.trim() + ";");
                }
            }
            if ((denyAllow = this.sqlHelper.findById(denyId, DenyAllow.class)) != null) {
                for (String ip : ips = denyAllow.getIp().split("\n")) {
                    strs.add("deny " + ip.trim() + ";");
                }
            }
        }
        if (denyAllowValue != 0) {
            String filename = this.addConfFile(confExt, "deny_" + id + ".conf", strs);
            NgxParam ngxParam = new NgxParam();
            ngxParam.addValue("include " + filename);
            ngxBlock.addEntry(ngxParam);
        }
    }

    public NgxBlock buildBlockUpstream(Upstream upstream) {
        NgxParam ngxParam = null;
        NgxBlock ngxBlockServer = new NgxBlock();
        ngxBlockServer.addValue("upstream " + upstream.getName());
        if (StrUtil.isNotEmpty(upstream.getDescr())) {
            String[] descrs = upstream.getDescr().split("\n");
            for (String d : descrs) {
                ngxParam = new NgxParam();
                ngxParam.addValue("# " + (String)d);
                ngxBlockServer.addEntry(ngxParam);
            }
        }
        if (StrUtil.isNotEmpty(upstream.getTactics())) {
            ngxParam = new NgxParam();
            ngxParam.addValue(upstream.getTactics());
            ngxBlockServer.addEntry(ngxParam);
        }
        List<UpstreamServer> upstreamServers = this.upstreamService.getUpstreamServers(upstream.getId());
        for (UpstreamServer upstreamServer : upstreamServers) {
            if (upstreamServer.getEnable() != 1) continue;
            ngxParam = new NgxParam();
            ngxParam.addValue("server " + this.buildNodeStr(upstreamServer));
            ngxBlockServer.addEntry(ngxParam);
        }
        List<Param> paramList = this.paramService.getListByTypeId(upstream.getId(), "upstream");
        for (Param param : paramList) {
            this.setSameParam(param, ngxBlockServer);
        }
        return ngxBlockServer;
    }

    public List<Integer> processPort(String listenString) {
        String[] partsByComma;
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String part : partsByComma = listenString.split(",")) {
            String[] range = part.split("-");
            if (range.length == 2) {
                int i;
                int end;
                int start = Integer.parseInt(range[0]);
                if (start <= (end = Integer.parseInt(range[1]))) {
                    for (i = start; i <= end; ++i) {
                        numbers.add(i);
                    }
                    continue;
                }
                for (i = start; i >= end; --i) {
                    numbers.add(i);
                }
                continue;
            }
            int num = Integer.parseInt(part);
            numbers.add(num);
        }
        return numbers;
    }

    public void httpListenPort(Server server, NgxBlock ngxBlockServer, Boolean isIpv6) {
        String host = null;
        List<Integer> ports = null;
        if (server.getListen().contains(":")) {
            int lastColonIndex = server.getListen().lastIndexOf(":");
            host = server.getListen().substring(0, lastColonIndex);
            ports = this.processPort(server.getListen().substring(lastColonIndex + 1));
        } else {
            ports = this.processPort(server.getListen());
        }
        String listenKey = null;
        listenKey = isIpv6 != false ? "listen [::]:" : (host != null ? "listen " + host + ":" : "listen ");
        String value = "";
        for (Integer port : ports) {
            NgxParam ngxParam = new NgxParam();
            value = listenKey + port;
            if (server.getDef() == 1) {
                value = value + " default_server";
            }
            if (server.getProxyProtocol() == 1) {
                value = value + " proxy_protocol";
            }
            if (server.getSsl() == 1) {
                value = value + " ssl";
                if (server.getHttp2() == 1) {
                    value = value + " http2";
                }
            }
            ngxParam.addValue(value);
            ngxBlockServer.addEntry(ngxParam);
        }
    }

    public void tcpListenPort(Server server, NgxBlock ngxBlockServer, Boolean isIpv6) {
        String host = null;
        List<Integer> ports = null;
        if (server.getListen().contains(":")) {
            int lastColonIndex = server.getListen().lastIndexOf(":");
            host = server.getListen().substring(0, lastColonIndex);
            ports = this.processPort(server.getListen().substring(lastColonIndex + 1));
        } else {
            ports = this.processPort(server.getListen());
        }
        String listenKey = null;
        listenKey = isIpv6 != false ? "listen [::]:" : (host != null ? "listen " + host + ":" : "listen ");
        String value = "";
        for (Integer port : ports) {
            NgxParam ngxParam = new NgxParam();
            value = listenKey + port;
            if (server.getProxyProtocol() == 1) {
                value = value + " proxy_protocol";
            }
            if (server.getProxyType() == 2) {
                value = value + " udp";
            }
            if (server.getSsl() != null && server.getSsl() == 1) {
                value = value + " ssl";
            }
            ngxParam.addValue(value);
            ngxBlockServer.addEntry(ngxParam);
        }
    }

    public NgxBlock bulidBlockServer(Server server, ConfExt confExt) {
        NgxParam ngxParam = null;
        NgxBlock ngxBlockServer = new NgxBlock();
        if (server.getProxyType() == 0) {
            Password password;
            ngxBlockServer.addValue("server");
            if (StrUtil.isNotEmpty(server.getDescr())) {
                String[] descrs;
                for (String d : descrs = server.getDescr().split("\n")) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("# " + d);
                    ngxBlockServer.addEntry(ngxParam);
                }
            }
            if (StrUtil.isNotEmpty(server.getServerName())) {
                ngxParam = new NgxParam();
                ngxParam.addValue("server_name " + server.getServerName());
                ngxBlockServer.addEntry(ngxParam);
            }
            this.httpListenPort(server, ngxBlockServer, false);
            if (server.getIpv6() == 1) {
                this.httpListenPort(server, ngxBlockServer, true);
            }
            if (server.getSsl() == 1 && server.getHttp2() == 2) {
                ngxParam = new NgxParam();
                ngxParam.addValue("http2 on");
                ngxBlockServer.addEntry(ngxParam);
            }
            if (StrUtil.isNotEmpty(server.getPasswordId()) && (password = this.sqlHelper.findById(server.getPasswordId(), Password.class)) != null) {
                ngxParam = new NgxParam();
                ngxParam.addValue("auth_basic \"" + password.getDescr() + "\"");
                ngxBlockServer.addEntry(ngxParam);
                ngxParam = new NgxParam();
                ngxParam.addValue("auth_basic_user_file " + password.getPath());
                ngxBlockServer.addEntry(ngxParam);
            }
            this.setServerSsl(server, ngxBlockServer);
            this.buildDenyAllow(ngxBlockServer, "server", server.getId(), confExt);
            String type = "server";
            if (server.getProxyType() != 0) {
                type = type + server.getProxyType();
            }
            List<Param> paramList = this.paramService.getListByTypeId(server.getId(), type);
            for (Param param : paramList) {
                this.setSameParam(param, ngxBlockServer);
            }
            List<Location> locationList = this.serverService.getLocationByServerId(server.getId());
            for (Location location : locationList) {
                if (location.getEnable() != 1) continue;
                NgxBlock ngxBlockLocation = new NgxBlock();
                ngxBlockLocation.addValue("location");
                ngxBlockLocation.addValue(location.getPath());
                if (StrUtil.isNotEmpty(location.getDescr())) {
                    String[] descrs;
                    for (String d : descrs = location.getDescr().split("\n")) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("# " + d);
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                }
                if (location.getType() == 0 || location.getType() == 2) {
                    Upstream upstream;
                    if (location.getType() == 0) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_pass " + location.getValue());
                        ngxBlockLocation.addEntry(ngxParam);
                    } else if (location.getType() == 2 && (upstream = this.sqlHelper.findById(location.getUpstreamId(), Upstream.class)) != null) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_pass " + location.getUpstreamType() + "://" + upstream.getName() + (location.getUpstreamPath() != null ? location.getUpstreamPath() : ""));
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                    if (location.getHeader() == 1) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header Host " + location.getHeaderHost());
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header X-Real-IP $remote_addr");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header X-Forwarded-Host $http_host");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header X-Forwarded-Port $server_port");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header X-Forwarded-Proto $scheme");
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                    if (location.getWebsocket() == 1) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_http_version 1.1");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header Upgrade $http_upgrade");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_set_header Connection \"upgrade\"");
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                    if (location.getCros() == 1) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("add_header Access-Control-Allow-Origin *");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("add_header Access-Control-Allow-Methods *");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("add_header Access-Control-Allow-Headers *");
                        ngxBlockLocation.addEntry(ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("add_header Access-Control-Allow-Credentials true");
                        ngxBlockLocation.addEntry(ngxParam);
                        NgxBlock ngxBlock = new NgxBlock();
                        ngxBlock.addValue("if ($request_method = 'OPTIONS')");
                        ngxParam = new NgxParam();
                        ngxParam.addValue("return 204");
                        ngxBlock.addEntry(ngxParam);
                        ngxBlockLocation.addEntry(ngxBlock);
                    }
                    if (server.getSsl() == 1 && server.getRewrite() == 1) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("proxy_redirect http:// https://");
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                } else if (location.getType() == 1) {
                    if (location.getRootType() != null && location.getRootType().equals("alias")) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("alias " + ToolUtils.handlePath(location.getRootPath()));
                        ngxBlockLocation.addEntry(ngxParam);
                    } else {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("root " + ToolUtils.handlePath(location.getRootPath()));
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                    if (StrUtil.isNotEmpty(location.getRootPage())) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("index " + location.getRootPage());
                        ngxBlockLocation.addEntry(ngxParam);
                    }
                } else if (location.getType() == 4) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("return 301 " + location.getReturnUrl() + (location.getReturnPath() == 1 ? "$request_uri" : ""));
                    ngxBlockLocation.addEntry(ngxParam);
                }
                paramList = this.paramService.getListByTypeId(location.getId(), "location");
                for (Param param : paramList) {
                    this.setSameParam(param, ngxBlockLocation);
                }
                ngxBlockServer.addEntry(ngxBlockLocation);
            }
        } else {
            Upstream upstream;
            ngxBlockServer.addValue("server");
            this.tcpListenPort(server, ngxBlockServer, false);
            if (server.getIpv6() == 1) {
                this.tcpListenPort(server, ngxBlockServer, true);
            }
            if ((upstream = this.sqlHelper.findById(server.getProxyUpstreamId(), Upstream.class)) != null) {
                ngxParam = new NgxParam();
                ngxParam.addValue("proxy_pass " + upstream.getName());
                ngxBlockServer.addEntry(ngxParam);
            }
            this.setServerSsl(server, ngxBlockServer);
            this.buildDenyAllow(ngxBlockServer, "server", server.getId(), confExt);
            String type = "server";
            if (server.getProxyType() != 0) {
                type = type + server.getProxyType();
            }
            List<Param> paramList = this.paramService.getListByTypeId(server.getId(), type);
            for (Param param : paramList) {
                this.setSameParam(param, ngxBlockServer);
            }
        }
        return ngxBlockServer;
    }

    private void setServerSsl(Server server, NgxBlock ngxBlockServer) {
        NgxParam ngxParam = null;
        if (server.getSsl() == 1) {
            if (StrUtil.isNotEmpty(server.getPem()) && StrUtil.isNotEmpty(server.getKey())) {
                ngxParam = new NgxParam();
                ngxParam.addValue("ssl_certificate " + ToolUtils.handlePath(server.getPem()));
                ngxBlockServer.addEntry(ngxParam);
                ngxParam = new NgxParam();
                ngxParam.addValue("ssl_certificate_key " + ToolUtils.handlePath(server.getKey()));
                ngxBlockServer.addEntry(ngxParam);
                if (StrUtil.isNotEmpty(server.getProtocols())) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("ssl_protocols " + server.getProtocols());
                    ngxBlockServer.addEntry(ngxParam);
                }
            }
            if (server.getProxyType() == 0 && server.getRewrite() == 1) {
                if (StrUtil.isNotEmpty(server.getRewriteListen())) {
                    ngxParam = new NgxParam();
                    String reValue = "listen " + server.getRewriteListen();
                    ngxParam.addValue(reValue);
                    ngxBlockServer.addEntry(ngxParam);
                    if (server.getIpv6() == 1) {
                        ngxParam = new NgxParam();
                        reValue = "listen [::]:" + this.replaceIp(server.getRewriteListen());
                        ngxParam.addValue(reValue);
                        ngxBlockServer.addEntry(ngxParam);
                    }
                }
                String port = this.replaceIp(server.getListen());
                NgxBlock ngxBlock = new NgxBlock();
                ngxBlock.addValue("if ($scheme = http)");
                ngxParam = new NgxParam();
                ngxParam.addValue("return 301 https://$host:" + port + "$request_uri");
                ngxBlock.addEntry(ngxParam);
                ngxBlockServer.addEntry(ngxBlock);
            }
        }
    }

    private String replaceIp(String listen) {
        if (listen.contains(":")) {
            return listen.split(":")[1];
        }
        return listen;
    }

    private boolean noContain(NgxBlock ngxBlockHttp, NgxParam ngxParam) {
        for (NgxEntry ngxEntry : ngxBlockHttp.getEntries()) {
            if (!ngxEntry.toString().equals(ngxParam.toString())) continue;
            return false;
        }
        return true;
    }

    public String buildNodeStr(UpstreamServer upstreamServer) {
        if (upstreamServer.getServer().contains(":")) {
            upstreamServer.setServer("[" + upstreamServer.getServer() + "]");
        }
        String conf = upstreamServer.getServer() + ":" + upstreamServer.getPort();
        if (upstreamServer.getWeight() != null) {
            conf = conf + " weight=" + upstreamServer.getWeight();
        }
        if (upstreamServer.getFailTimeout() != null) {
            conf = conf + " fail_timeout=" + upstreamServer.getFailTimeout() + "s";
        }
        if (upstreamServer.getMaxFails() != null) {
            conf = conf + " max_fails=" + upstreamServer.getMaxFails();
        }
        if (upstreamServer.getMaxConns() != null) {
            conf = conf + " max_conns=" + upstreamServer.getMaxConns();
        }
        if (!"none".equals(upstreamServer.getStatus())) {
            conf = conf + " " + upstreamServer.getStatus();
        }
        if (upstreamServer.getParam() != null) {
            conf = conf + " " + upstreamServer.getParam();
        }
        return conf;
    }

    private void setSameParam(Param param, NgxBlock ngxBlock) {
        if (StrUtil.isEmpty(param.getTemplateValue())) {
            NgxParam ngxParam = new NgxParam();
            if (StrUtil.isNotEmpty(param.getName().trim())) {
                param.setName(param.getName().trim() + " ");
            }
            ngxParam.addValue(param.getName() + param.getValue().trim());
            ngxBlock.addEntry(ngxParam);
        } else {
            List<Param> params = this.templateService.getParamList(param.getTemplateValue());
            for (Param paramSub : params) {
                NgxParam ngxParam = new NgxParam();
                if (StrUtil.isNotEmpty(paramSub.getName().trim())) {
                    paramSub.setName(paramSub.getName().trim() + " ");
                }
                ngxParam.addValue(paramSub.getName() + paramSub.getValue().trim());
                ngxBlock.addEntry(ngxParam);
            }
        }
    }

    private String addConfFile(ConfExt confExt, String name, List<String> strs) {
        name = name.replace(" ", "_").replaceAll("[!@#$%^&*()_+=\\{\\}\\[\\]\"<>,/;':\\\\|`~]+", "_");
        boolean hasSameName = false;
        for (ConfFile confFile : confExt.getFileList()) {
            if (!confFile.getName().equals(name)) continue;
            confFile.setConf(confFile.getConf() + "\n" + this.buildStr(strs));
            hasSameName = true;
        }
        if (!hasSameName) {
            ConfFile confFile = new ConfFile();
            confFile.setName(name);
            confFile.setConf(this.buildStr(strs));
            confExt.getFileList().add(confFile);
        }
        return "conf.d/" + name;
    }

    private String addConfFile(ConfExt confExt, String name, NgxBlock ngxBlockServer) {
        name = name.replace(" ", "_").replaceAll("[!@#$%^&*()_+=\\{\\}\\[\\]\"<>,/;':\\\\|`~]+", "_");
        boolean hasSameName = false;
        for (ConfFile confFile : confExt.getFileList()) {
            if (!confFile.getName().equals(name)) continue;
            confFile.setConf(confFile.getConf() + "\n" + this.buildStr(ngxBlockServer));
            hasSameName = true;
        }
        if (!hasSameName) {
            ConfFile confFile = new ConfFile();
            confFile.setName(name);
            confFile.setConf(this.buildStr(ngxBlockServer));
            confExt.getFileList().add(confFile);
        }
        return "conf.d/" + name;
    }

    private String buildStr(NgxBlock ngxBlockServer) {
        NgxConfig ngxConfig = new NgxConfig();
        ngxConfig.addEntry(ngxBlockServer);
        return ToolUtils.handleConf(new NgxDumper(ngxConfig).dump());
    }

    private String buildStr(List<String> strs) {
        return StrUtil.join((CharSequence)"\n", strs);
    }

    public void replace(String nginxPath, String nginxContent, List<String> subContent, List<String> subName, Boolean isReplace, String adminName) {
        String beforeConf = null;
        if (isReplace.booleanValue()) {
            beforeConf = FileUtil.readString(nginxPath, StandardCharsets.UTF_8);
        }
        String confd = new File(nginxPath).getParent().replace("\\", "/") + "/conf.d/";
        FileUtil.del(confd);
        FileUtil.mkdir(confd);
        FileUtil.writeString(nginxContent, nginxPath.replace(" ", "_"), StandardCharsets.UTF_8);
        if (subContent != null && subName != null) {
            for (int i = 0; i < subContent.size(); ++i) {
                String tagert = (new File(nginxPath).getParent().replace("\\", "/") + "/conf.d/" + subName.get(i)).replace(" ", "_");
                FileUtil.writeString(subContent.get(i), tagert, StandardCharsets.UTF_8);
            }
        }
        ClassPathResource resource = new ClassPathResource("conf.zip");
        InputStream inputStream = resource.getStream();
        ZipUtil.unzip(inputStream, new File(new File(nginxPath).getParent().replace("\\", "/")), CharsetUtil.defaultCharset());
        if (isReplace.booleanValue()) {
            Bak bak = new Bak();
            bak.setTime(DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            bak.setContent(nginxContent);
            this.sqlHelper.insert(bak);
            for (int i = 0; i < subContent.size(); ++i) {
                BakSub bakSub = new BakSub();
                bakSub.setBakId(bak.getId());
                bakSub.setName(subName.get(i));
                bakSub.setContent(subContent.get(i));
                this.sqlHelper.insert(bakSub);
            }
            if (StrUtil.isNotEmpty(adminName)) {
                this.operateLogService.addLog(beforeConf, nginxContent, adminName);
            }
        }
    }

    public AsycPack getAsycPack(String[] asycData) {
        AsycPack asycPack = new AsycPack();
        if (this.hasStr(asycData, "basic") || this.hasStr(asycData, "all")) {
            asycPack.setBasicList(this.sqlHelper.findAll(Basic.class));
        }
        if (this.hasStr(asycData, "http") || this.hasStr(asycData, "all")) {
            asycPack.setHttpList(this.sqlHelper.findAll(Http.class));
        }
        if (this.hasStr(asycData, "server") || this.hasStr(asycData, "all")) {
            List<Server> serverList = this.sqlHelper.findAll(Server.class);
            for (Server server : serverList) {
                if (StrUtil.isNotEmpty(server.getPem()) && FileUtil.exist(server.getPem())) {
                    server.setPemStr(FileUtil.readString(server.getPem(), StandardCharsets.UTF_8));
                }
                if (!StrUtil.isNotEmpty(server.getKey()) || !FileUtil.exist(server.getKey())) continue;
                server.setKeyStr(FileUtil.readString(server.getKey(), StandardCharsets.UTF_8));
            }
            asycPack.setServerList(serverList);
            asycPack.setLocationList(this.sqlHelper.findAll(Location.class));
        }
        if (this.hasStr(asycData, "password") || this.hasStr(asycData, "all")) {
            List<Password> passwordList = this.sqlHelper.findAll(Password.class);
            for (Password password : passwordList) {
                if (!StrUtil.isNotEmpty(password.getPath()) || !FileUtil.exist(password.getPath())) continue;
                password.setPathStr(FileUtil.readString(password.getPath(), StandardCharsets.UTF_8));
            }
            asycPack.setPasswordList(passwordList);
        }
        if (this.hasStr(asycData, "upstream") || this.hasStr(asycData, "all")) {
            asycPack.setUpstreamList(this.sqlHelper.findAll(Upstream.class));
            asycPack.setUpstreamServerList(this.sqlHelper.findAll(UpstreamServer.class));
        }
        if (this.hasStr(asycData, "stream") || this.hasStr(asycData, "all")) {
            asycPack.setStreamList(this.sqlHelper.findAll(Stream.class));
        }
        if (this.hasStr(asycData, "param") || this.hasStr(asycData, "all")) {
            asycPack.setTemplateList(this.sqlHelper.findAll(Template.class));
            asycPack.setParamList(this.sqlHelper.findAll(Param.class));
        }
        if (this.hasStr(asycData, "cert") || this.hasStr(asycData, "all")) {
            asycPack.setCertList(this.sqlHelper.findAll(Cert.class));
            asycPack.setCertCodeList(this.sqlHelper.findAll(CertCode.class));
            asycPack.setAcmeZip(this.certService.getAcmeZipBase64());
            asycPack.setCertZip(this.certService.getCertZipBase64());
        }
        if (this.hasStr(asycData, "denyAllow") || this.hasStr(asycData, "all")) {
            asycPack.setDenyAllowList(this.sqlHelper.findAll(DenyAllow.class));
        }
        return asycPack;
    }

    private boolean hasStr(String[] asycData, String data) {
        for (String str : asycData) {
            if (!str.equals(data)) continue;
            return true;
        }
        return false;
    }

    public void setAsycPack(AsycPack asycPack) {
        try {
            if (asycPack.getBasicList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Basic.class);
                this.sqlHelper.insertAll(asycPack.getBasicList());
            }
            if (asycPack.getHttpList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Http.class);
                this.sqlHelper.insertAll(asycPack.getHttpList());
            }
            if (asycPack.getServerList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Server.class);
                this.sqlHelper.insertAll(asycPack.getServerList());
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Location.class);
                this.sqlHelper.insertAll(asycPack.getLocationList());
                for (Server server : asycPack.getServerList()) {
                    try {
                        if (StrUtil.isNotEmpty(server.getPem()) && StrUtil.isNotEmpty(server.getPemStr())) {
                            String pemPath = SystemTool.isWindows() != false ? server.getPem().replace("*", "_") : server.getPem();
                            FileUtil.writeString(server.getPemStr(), pemPath, StandardCharsets.UTF_8);
                        }
                        if (!StrUtil.isNotEmpty(server.getKey()) || !StrUtil.isNotEmpty(server.getKeyStr())) continue;
                        String keyPath = SystemTool.isWindows() != false ? server.getKey().replace("*", "_") : server.getKey();
                        FileUtil.writeString(server.getKeyStr(), keyPath, StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (asycPack.getUpstreamList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Upstream.class);
                this.sqlHelper.insertAll(asycPack.getUpstreamList());
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), UpstreamServer.class);
                this.sqlHelper.insertAll(asycPack.getUpstreamServerList());
            }
            if (asycPack.getStreamList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Stream.class);
                this.sqlHelper.insertAll(asycPack.getStreamList());
            }
            if (asycPack.getTemplateList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Template.class);
                this.sqlHelper.insertAll(asycPack.getTemplateList());
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Param.class);
                this.sqlHelper.insertAll(asycPack.getParamList());
            }
            if (asycPack.getDenyAllowList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), DenyAllow.class);
                this.sqlHelper.insertAll(asycPack.getDenyAllowList());
            }
            if (asycPack.getPasswordList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Password.class);
                this.sqlHelper.insertAll(asycPack.getPasswordList());
                for (Password password : asycPack.getPasswordList()) {
                    if (!StrUtil.isNotEmpty(password.getPath()) || !StrUtil.isNotEmpty(password.getPathStr())) continue;
                    FileUtil.writeString(password.getPathStr(), password.getPath(), StandardCharsets.UTF_8);
                }
            }
            if (asycPack.getCertList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), Cert.class);
                this.sqlHelper.insertAll(asycPack.getCertList());
            }
            if (asycPack.getCertCodeList() != null) {
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), CertCode.class);
                this.sqlHelper.insertAll(asycPack.getCertCodeList());
            }
            if (asycPack.getAcmeZip() != null) {
                this.certService.writeAcmeZipBase64(asycPack.getAcmeZip());
            }
            if (asycPack.getCertZip() != null) {
                this.certService.writeCertZipBase64(asycPack.getCertZip());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public List<Cert> getApplyCerts() {
        List<Cert> certs = this.sqlHelper.findListByQuery(new ConditionAndWrapper().ne(Cert::getType, (Object)1), Cert.class);
        return certs;
    }
}

