/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import com.cym.model.Http;
import com.cym.model.Param;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.SnowFlakeUtils;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class HttpService {
    @Inject
    SqlHelper sqlHelper;

    public List<Http> findAll() {
        return this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Http.class);
    }

    public void setAll(List<Http> https) {
        Http logFormat = null;
        Http accessLog = null;
        for (Http http : https) {
            if (http.getName().equals("log_format")) {
                logFormat = http;
            }
            if (!http.getName().equals("access_log")) continue;
            accessLog = http;
        }
        if (logFormat != null) {
            https.remove(logFormat);
            https.add(logFormat);
        }
        if (accessLog != null) {
            https.remove(accessLog);
            https.add(accessLog);
        }
        for (Http http : https) {
            Http httpOrg = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq("name", (Object)http.getName()), Http.class);
            if (httpOrg != null) {
                http.setId(httpOrg.getId());
            }
            http.setSeq(SnowFlakeUtils.getId());
            http.setValue(http.getValue() + http.getUnit());
            this.sqlHelper.insertOrUpdate(http);
        }
    }

    public void setSeq(String httpId, Integer seqAdd) {
        Http http = this.sqlHelper.findById(httpId, Http.class);
        List<Http> httpList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Http.class);
        if (httpList.size() > 0) {
            int i;
            Http tagert = null;
            if (seqAdd < 0) {
                for (i = 0; i < httpList.size(); ++i) {
                    if (httpList.get(i).getSeq() >= http.getSeq()) continue;
                    tagert = httpList.get(i);
                }
            } else {
                for (i = httpList.size() - 1; i >= 0; --i) {
                    if (httpList.get(i).getSeq() <= http.getSeq()) continue;
                    tagert = httpList.get(i);
                }
            }
            if (tagert != null) {
                Long seq = tagert.getSeq();
                tagert.setSeq(http.getSeq());
                http.setSeq(seq);
                this.sqlHelper.updateById(tagert);
                this.sqlHelper.updateById(http);
            }
        }
    }

    public Http getName(String name) {
        Http http = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq("name", (Object)name), Http.class);
        return http;
    }

    public void addTemplate(String templateId) {
        List<Param> parmList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(Param::getTemplateId, (Object)templateId), Param.class);
        for (Param param : parmList) {
            Http http = new Http();
            http.setName(param.getName());
            http.setValue(param.getValue());
            http.setSeq(SnowFlakeUtils.getId());
            this.sqlHelper.insert(http);
        }
    }
}

