/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.system.oshi.OshiUtil;
import com.cym.ext.DiskInfo;
import com.cym.ext.MonitorInfo;
import com.cym.ext.NetworkInfo;
import com.cym.utils.OshiUtils;
import com.cym.utils.SystemTool;
import com.cym.utils.oshi.NetDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.OSFileStore;
import oshi.util.FormatUtil;
import oshi.util.GlobalConfig;

@Component
public class MonitorService {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Init
    public void afterInjection() {
        if (SystemTool.isWindows().booleanValue()) {
            GlobalConfig.set("oshi.os.windows.cpu.utility", true);
        }
    }

    public MonitorInfo getMonitorInfoOshi() {
        MonitorInfo infoBean = new MonitorInfo();
        try {
            infoBean.setCpuCount(OshiUtil.getProcessor().getPhysicalProcessorCount());
            infoBean.setThreadCount(OshiUtil.getProcessor().getLogicalProcessorCount());
            infoBean.setUsedMemory(FormatUtil.formatBytes(OshiUtil.getMemory().getTotal() - OshiUtil.getMemory().getAvailable()));
            infoBean.setTotalMemorySize(FormatUtil.formatBytes(OshiUtil.getMemory().getTotal()));
            infoBean.setCpuRatio(NumberUtil.decimalFormat("#.00", 100.0 - OshiUtil.getCpuInfo().getFree()) + "%");
            infoBean.setMemRatio(NumberUtil.decimalFormat("#.##%", NumberUtil.div((float)(OshiUtil.getMemory().getTotal() - OshiUtil.getMemory().getAvailable()), (float)OshiUtil.getMemory().getTotal())));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return infoBean;
    }

    public List<DiskInfo> getDiskInfo() {
        ArrayList<DiskInfo> list = new ArrayList<DiskInfo>();
        try {
            for (OSFileStore fs : OshiUtil.getOs().getFileSystem().getFileStores()) {
                DiskInfo diskInfo = new DiskInfo();
                diskInfo.setPath(fs.getMount());
                diskInfo.setUseSpace(FormatUtil.formatBytes(fs.getTotalSpace() - fs.getUsableSpace()));
                diskInfo.setTotalSpace(FormatUtil.formatBytes(fs.getTotalSpace()));
                if (fs.getTotalSpace() != 0L) {
                    diskInfo.setPercent(NumberUtil.decimalFormat("#.##%", NumberUtil.div((float)(fs.getTotalSpace() - fs.getUsableSpace()), (float)fs.getTotalSpace())));
                } else {
                    diskInfo.setPercent(NumberUtil.decimalFormat("#.##%", 0L));
                }
                list.add(diskInfo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return list;
    }

    public NetworkInfo getNetworkInfo() {
        NetworkInfo networkInfo = new NetworkInfo();
        NetDomain netDomain = OshiUtils.getNetInfo();
        networkInfo.setSend(this.getNetUp(netDomain));
        networkInfo.setReceive(this.getNetDown(netDomain));
        networkInfo.setTime(DateUtil.format(new Date(), "HH:mm:ss"));
        return networkInfo;
    }

    private Double getNetUp(NetDomain netDomain) {
        Double uploadBps = 0.0;
        if (netDomain != null) {
            for (NetDomain.NetInterfaceDomain netInterfaceDomain : netDomain.getNetList()) {
                uploadBps = uploadBps + netInterfaceDomain.getUploadBps();
            }
        }
        return uploadBps;
    }

    private Double getNetDown(NetDomain netDomain) {
        Double downloadBps = 0.0;
        if (netDomain != null) {
            for (NetDomain.NetInterfaceDomain netInterfaceDomain : netDomain.getNetList()) {
                downloadBps = downloadBps + netInterfaceDomain.getDownloadBps();
            }
        }
        return downloadBps;
    }
}

