/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.cym.model.Param;
import com.cym.model.Template;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class ParamService {
    @Inject
    SqlHelper sqlHelper;

    public String getJsonByTypeId(String id, String type) {
        List<Param> list = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(type + "Id", (Object)id), Param.class);
        for (Param param : list) {
            if (!StrUtil.isNotEmpty(param.getTemplateValue())) continue;
            Template template = this.sqlHelper.findById(param.getTemplateValue(), Template.class);
            param.setTemplateName(template.getName());
        }
        return JSONUtil.toJsonStr(list);
    }

    public List<Param> getListByTypeId(String id, String type) {
        ArrayList<Param> list = new ArrayList<Param>();
        List<Template> templateList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(Template::getDef, (Object)type), Template.class);
        for (Template template : templateList) {
            List<Param> addList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(Param::getTemplateId, (Object)template.getId()), Param.class);
            list.addAll(addList);
        }
        if (type.contains("server")) {
            type = "server";
        }
        list.addAll(this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(type + "Id", (Object)id), Param.class));
        return list;
    }

    public List<Param> getList(String serverId, String locationId, String upstreamId) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isNotEmpty(serverId)) {
            conditionAndWrapper.eq("serverId", (Object)serverId);
        }
        if (StrUtil.isNotEmpty(locationId)) {
            conditionAndWrapper.eq("locationId", (Object)locationId);
        }
        if (StrUtil.isNotEmpty(upstreamId)) {
            conditionAndWrapper.eq("upstreamId", (Object)upstreamId);
        }
        return this.sqlHelper.findListByQuery(conditionAndWrapper, Param.class);
    }
}

