/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import com.cym.model.Admin;
import com.cym.model.Group;
import com.cym.model.Remote;
import com.cym.service.AdminService;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.ConditionOrWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.util.HashMap;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RemoteService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    SqlHelper sqlHelper;
    @Inject
    AdminService adminService;

    public void getCreditKey(Remote remote, String code, String auth) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("name", Base64.encode(Base64.encode(remote.getName())));
        paramMap.put("pass", Base64.encode(Base64.encode(remote.getPass())));
        paramMap.put("code", Base64.encode(Base64.encode(code)));
        paramMap.put("auth", auth);
        try {
            JSONObject jsonObject;
            String rs = HttpUtil.post(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/login/getCredit", paramMap, 2000);
            if (StrUtil.isNotEmpty(rs) && (jsonObject = new JSONObject(rs)).getBool("success").booleanValue()) {
                remote.setSystem(jsonObject.getJSONObject("obj").getStr("system"));
                remote.setCreditKey(jsonObject.getJSONObject("obj").getStr("creditKey"));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public List<Remote> getBySystem(String system) {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("system", (Object)system), Remote.class);
    }

    public List<Remote> getListByParent(String parentId) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isEmpty(parentId)) {
            conditionAndWrapper.and(new ConditionOrWrapper().eq("parentId", (Object)"").isNull("parentId"));
        } else {
            conditionAndWrapper.eq("parentId", (Object)parentId);
        }
        return this.sqlHelper.findListByQuery(conditionAndWrapper, Remote.class);
    }

    public List<Remote> getMonitorRemoteList() {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("monitor", (Object)1), Remote.class);
    }

    public boolean hasSame(Remote remote) {
        Long count = 0L;
        count = StrUtil.isEmpty(remote.getId()) ? this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("ip", (Object)remote.getIp()).eq("port", (Object)remote.getPort()), Remote.class) : this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("ip", (Object)remote.getIp()).eq("port", (Object)remote.getPort()).ne("id", (Object)remote.getId()), Remote.class);
        return count > 0L;
    }

    public List<Group> getGroupByAdmin(Admin admin) {
        if (admin.getType() == 0) {
            return this.sqlHelper.findAll(Group.class);
        }
        List<String> groupIds = this.adminService.getGroupIds(admin.getId());
        return this.sqlHelper.findListByIds(groupIds, Group.class);
    }
}

