/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.beust.jcommander.internal.Lists;
import com.cym.model.Location;
import com.cym.model.Param;
import com.cym.model.Server;
import com.cym.sqlhelper.bean.BaseModel;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.ConditionOrWrapper;
import com.cym.sqlhelper.utils.ConditionWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.SnowFlakeUtils;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ServerService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    SqlHelper sqlHelper;

    public Page search(Page page, String keywords) {
        ConditionOrWrapper conditionOrWrapper = new ConditionOrWrapper();
        if (StrUtil.isNotEmpty(keywords)) {
            conditionOrWrapper.like(Server::getDescr, keywords.trim()).like(Server::getServerName, keywords.trim()).like(Server::getListen, keywords.trim());
            List<String> serverIds = this.sqlHelper.findPropertiesByQuery((ConditionWrapper)new ConditionOrWrapper().like(Location::getDescr, keywords).like(Location::getValue, keywords).like(Location::getPath, keywords), Location.class, Location::getServerId);
            conditionOrWrapper.in(BaseModel::getId, serverIds);
        }
        Sort sort = new Sort().add("seq", Sort.Direction.DESC);
        page = this.sqlHelper.findPage(conditionOrWrapper, sort, page, Server.class);
        return page;
    }

    public void deleteById(String id) {
        Object[] ids = id.split(",");
        this.sqlHelper.deleteByIds((String[])ids, Server.class);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().in("serverId", ids), Location.class);
    }

    public List<Location> getLocationByServerId(String serverId) {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("serverId", (Object)serverId), Location.class);
    }

    public void addOver(Server server, String serverParamJson, List<Location> locations) {
        this.sqlHelper.insertOrUpdate(server);
        List<Object> paramList = new ArrayList();
        if (StrUtil.isNotEmpty(serverParamJson) && JSONUtil.isTypeJSON(serverParamJson)) {
            paramList = JSONUtil.toList(JSONUtil.parseArray(serverParamJson), Param.class);
        }
        List<String> locationIds = this.sqlHelper.findIdsByQuery(new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        this.sqlHelper.deleteByQuery(new ConditionOrWrapper().eq("serverId", (Object)server.getId()).in("locationId", locationIds), Param.class);
        Collections.reverse(paramList);
        for (Param param : paramList) {
            param.setServerId(server.getId());
            this.sqlHelper.insert(param);
        }
        List<Location> locationOlds = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        if (locations != null) {
            Collections.reverse(locations);
            for (Location location : locations) {
                location.setServerId(server.getId());
                location.setDescr(this.findLocationDescr(locationOlds, location));
                this.sqlHelper.insert(location);
                paramList = new ArrayList();
                if (StrUtil.isNotEmpty(location.getLocationParamJson()) && JSONUtil.isJson(location.getLocationParamJson())) {
                    paramList = JSONUtil.toList(JSONUtil.parseArray(location.getLocationParamJson()), Param.class);
                }
                Collections.reverse(paramList);
                for (Param param : paramList) {
                    param.setLocationId(location.getId());
                    this.sqlHelper.insert(param);
                }
            }
        }
    }

    private String findLocationDescr(List<Location> locationOlds, Location locationNew) {
        for (Location location : locationOlds) {
            if (!location.getPath().equals(locationNew.getPath()) || !location.getType().equals(locationNew.getType())) continue;
            return location.getDescr();
        }
        return null;
    }

    public void addOverTcp(Server server, String serverParamJson) {
        this.sqlHelper.insertOrUpdate(server);
        List<String> locationIds = this.sqlHelper.findIdsByQuery(new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        this.sqlHelper.deleteByQuery(new ConditionOrWrapper().eq("serverId", (Object)server.getId()).in("locationId", locationIds), Param.class);
        List<Object> paramList = new ArrayList();
        if (StrUtil.isNotEmpty(serverParamJson) && JSONUtil.isTypeJSON(serverParamJson)) {
            paramList = JSONUtil.toList(JSONUtil.parseArray(serverParamJson), Param.class);
        }
        Collections.reverse(paramList);
        for (Param param : paramList) {
            param.setServerId(server.getId());
            this.sqlHelper.insert(param);
        }
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
    }

    public List<Server> getListByProxyType(String[] proxyType) {
        Sort sort = new Sort().add("seq", Sort.Direction.DESC);
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().in("proxyType", (Object[])proxyType), sort, Server.class);
    }

    public void importServer(String nginxPath) throws Exception {
        String initNginxPath = this.initNginx(nginxPath);
        NgxConfig conf = null;
        try {
            conf = NgxConfig.read(initNginxPath);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new Exception("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        List<NgxEntry> servers = conf.findAll(NgxConfig.BLOCK, "server");
        servers.addAll(conf.findAll(NgxConfig.BLOCK, "http", "server"));
        Collections.reverse(servers);
        for (NgxEntry ngxEntry : servers) {
            NgxBlock serverNgx = (NgxBlock)ngxEntry;
            NgxParam serverName = serverNgx.findParam("server_name");
            Server server = new Server();
            if (serverName == null) {
                server.setServerName("");
            } else {
                server.setServerName(serverName.getValue());
            }
            server.setProxyType(0);
            List<NgxEntry> listens = serverNgx.findAll(NgxConfig.PARAM, "listen");
            for (NgxEntry item3 : listens) {
                NgxParam param = (NgxParam)item3;
                if (server.getListen() == null) {
                    server.setListen((String)param.getValues().toArray()[0]);
                }
                if (param.getTokens().stream().anyMatch(item2 -> "ssl".equals(item2.getToken()))) {
                    server.setSsl(1);
                    NgxParam key = serverNgx.findParam("ssl_certificate_key");
                    NgxParam perm = serverNgx.findParam("ssl_certificate");
                    server.setKey(key == null ? "" : key.getValue());
                    server.setPem(perm == null ? "" : perm.getValue());
                }
                if (!param.getTokens().stream().anyMatch(item2 -> "http2".equals(item2.getToken()))) continue;
                server.setHttp2(1);
            }
            long rewriteCount = serverNgx.getEntries().stream().filter(item -> {
                if (item instanceof NgxBlock) {
                    NgxBlock itemNgx = (NgxBlock)item;
                    return itemNgx.getEntries().toString().contains("rewrite");
                }
                return false;
            }).count();
            if (rewriteCount > 0L) {
                server.setRewrite(1);
            } else {
                server.setRewrite(0);
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            List<NgxEntry> locationBlocks = serverNgx.findAll(NgxBlock.class, "location");
            for (NgxEntry item4 : locationBlocks) {
                Location location = new Location();
                NgxBlock locationBlockTemp = (NgxBlock)item4;
                NgxParam proxyPassParam = locationBlockTemp.findParam("proxy_pass");
                location.setPath(((NgxBlock)item4).getValue());
                if (proxyPassParam != null) {
                    location.setValue(proxyPassParam.getValue());
                    location.setType(0);
                } else {
                    NgxParam rootParam = ((NgxBlock)item4).findParam("root");
                    if (rootParam == null) {
                        rootParam = ((NgxBlock)item4).findParam("alias");
                    }
                    if (rootParam == null) continue;
                    location.setRootType(rootParam.getName());
                    location.setRootPath(rootParam.getValue());
                    NgxParam indexParam = ((NgxBlock)item4).findParam("index");
                    if (indexParam != null) {
                        location.setRootPage(indexParam.getValue());
                    }
                    location.setType(1);
                }
                location.setLocationParamJson(this.getParamJsonFromLocationBlock(locationBlockTemp));
                location.setHeader(0);
                locations.add(location);
            }
            server.setDef(0);
            server.setSeq(SnowFlakeUtils.getId());
            this.addOver(server, "", locations);
        }
        FileUtil.del(initNginxPath);
    }

    private String getParamJsonFromLocationBlock(NgxBlock locationBlock) {
        List<String> proxyConfigList = Lists.newArrayList("proxy_http_version", "proxy_redirect", "proxy_set_header", "proxy_cache", "proxy_cache_valid", "proxy_cache_key", "proxy_connect_timeout", "proxy_read_timeout", "proxy_send_timeout", "proxy_buffer_size", "proxy_buffers", "proxy_busy_buffers_size", "proxy_cookie_path", "proxy_intercept_errors", "proxy_request_buffering", "proxy_buffering", "proxy_ignore_client_abort", "expires", "add_header", "client_max_body_size");
        Collection<NgxEntry> entries = locationBlock.getEntries();
        JSONObject paramJsonTemp = null;
        JSONArray paramJsonArray = new JSONArray();
        for (String proxyConfig : proxyConfigList) {
            List<NgxEntry> paramsTemp = locationBlock.findAll(NgxParam.class, proxyConfig);
            if (paramsTemp == null || paramsTemp.isEmpty()) continue;
            for (NgxEntry paramEntry : paramsTemp) {
                NgxParam ngxParamTemp = (NgxParam)paramEntry;
                ngxParamTemp.getName();
                paramJsonTemp = new JSONObject();
                paramJsonTemp.put("name", (Object)ngxParamTemp.getName());
                paramJsonTemp.put("value", (Object)ngxParamTemp.getValue());
                paramJsonArray.add(paramJsonTemp);
            }
        }
        if (!paramJsonArray.isEmpty()) {
            return paramJsonArray.toString();
        }
        return null;
    }

    private String initNginx(String nginxPath) {
        List<String> lines = FileUtil.readLines(nginxPath, CharsetUtil.CHARSET_UTF_8);
        ArrayList<String> rs = new ArrayList<String>();
        for (String str : lines) {
            if (str.trim().indexOf("#") == 0) continue;
            rs.add(str);
        }
        String initNginxPath = FileUtil.getTmpDirPath() + UUID.randomUUID();
        FileUtil.writeLines(rs, initNginxPath, CharsetUtil.CHARSET_UTF_8);
        return initNginxPath;
    }

    public void setSeq(String serverId, Integer seqAdd) {
        Server server = this.sqlHelper.findById(serverId, Server.class);
        List<Server> serverList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.DESC), Server.class);
        if (serverList.size() > 0) {
            int i;
            Server tagert = null;
            if (seqAdd < 0) {
                for (i = 0; i < serverList.size(); ++i) {
                    if (serverList.get(i).getSeq() >= server.getSeq()) continue;
                    tagert = serverList.get(i);
                    break;
                }
            } else {
                for (i = serverList.size() - 1; i >= 0; --i) {
                    if (serverList.get(i).getSeq() <= server.getSeq()) continue;
                    tagert = serverList.get(i);
                    break;
                }
            }
            if (tagert != null) {
                System.err.println("tagert:" + tagert.getServerName() + tagert.getListen());
                System.err.println("server:" + server.getServerName() + server.getListen());
                Long seq = tagert.getSeq();
                tagert.setSeq(server.getSeq());
                server.setSeq(seq);
                this.sqlHelper.updateById(tagert);
                this.sqlHelper.updateById(server);
            }
        }
    }

    public void moveLocation(String locationId, Integer seqAdd) {
        Location location = this.sqlHelper.findById(locationId, Location.class);
        List<Location> locationList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(Location::getServerId, (Object)location.getServerId()), new Sort("id", Sort.Direction.DESC), Location.class);
        if (locationList.size() > 0) {
            int i;
            BaseModel tagert = null;
            if (seqAdd > 0) {
                for (i = 0; i < locationList.size(); ++i) {
                    if (Long.parseLong(locationList.get(i).getId()) >= Long.parseLong(location.getId())) continue;
                    tagert = locationList.get(i);
                }
            } else {
                for (i = locationList.size() - 1; i >= 0; --i) {
                    if (Long.parseLong(locationList.get(i).getId()) <= Long.parseLong(location.getId())) continue;
                    tagert = locationList.get(i);
                }
            }
            if (tagert != null) {
                String id = tagert.getId();
                tagert.setId(location.getId());
                location.setId(id);
                this.sqlHelper.updateById(tagert);
                this.sqlHelper.updateById(location);
            }
        }
    }
}

