/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import com.cym.model.Param;
import com.cym.model.Stream;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.SnowFlakeUtils;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class StreamService {
    @Inject
    SqlHelper sqlHelper;

    public void setSeq(String streamId, Integer seqAdd) {
        Stream http = this.sqlHelper.findById(streamId, Stream.class);
        List<Stream> httpList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Stream.class);
        if (httpList.size() > 0) {
            int i;
            Stream tagert = null;
            if (seqAdd < 0) {
                for (i = 0; i < httpList.size(); ++i) {
                    if (httpList.get(i).getSeq() >= http.getSeq()) continue;
                    tagert = httpList.get(i);
                }
            } else {
                for (i = httpList.size() - 1; i >= 0; --i) {
                    if (httpList.get(i).getSeq() <= http.getSeq()) continue;
                    tagert = httpList.get(i);
                }
            }
            if (tagert != null) {
                Long seq = tagert.getSeq();
                tagert.setSeq(http.getSeq());
                http.setSeq(seq);
                this.sqlHelper.updateById(tagert);
                this.sqlHelper.updateById(http);
            }
        }
    }

    public List<Stream> findAll() {
        return this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Stream.class);
    }

    public void addTemplate(String templateId) {
        List<Param> parmList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq(Param::getTemplateId, (Object)templateId), Param.class);
        for (Param param : parmList) {
            Stream stream = new Stream();
            stream.setName(param.getName());
            stream.setValue(param.getValue());
            stream.setSeq(SnowFlakeUtils.getId());
            this.sqlHelper.insert(stream);
        }
    }

    public void setAll(List<Stream> streams) {
        for (Stream stream : streams) {
            Stream streamOrg = this.sqlHelper.findOneByQuery(new ConditionAndWrapper().eq("name", (Object)stream.getName()), Stream.class);
            if (streamOrg != null) {
                this.sqlHelper.deleteById(streamOrg.getId(), Stream.class);
            }
            this.sqlHelper.insert(stream);
        }
    }
}

