/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import com.cym.model.Param;
import com.cym.model.Template;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.util.Collections;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class TemplateService {
    @Inject
    SqlHelper sqlHelper;

    public void addOver(Template template, List<Param> params) {
        this.sqlHelper.insertOrUpdate(template);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq("templateId", (Object)template.getId()), Param.class);
        Collections.reverse(params);
        for (Param param : params) {
            param.setTemplateId(template.getId());
            this.sqlHelper.insertOrUpdate(param);
        }
    }

    public List<Param> getParamList(String templateId) {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("templateId", (Object)templateId), Param.class);
    }

    public void del(String id) {
        Object[] ids = id.split(",");
        this.sqlHelper.deleteByIds((String[])ids, Template.class);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().in("templateId", ids), Param.class);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().in("templateValue", ids), Param.class);
    }

    public Long getCountByName(String name) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("name", (Object)name), Template.class);
    }

    public Long getCountByNameWithOutId(String name, String id) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("name", (Object)name).ne("id", (Object)id), Template.class);
    }
}

