/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.cym.model.Param;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.bean.Update;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.ConditionOrWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class UpstreamService {
    @Inject
    SqlHelper sqlHelper;

    public Page search(Page page, String word) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isNotEmpty(word)) {
            conditionAndWrapper.and(new ConditionOrWrapper().like("name", word));
        }
        page = this.sqlHelper.findPage(conditionAndWrapper, new Sort("seq", Sort.Direction.DESC), page, Upstream.class);
        return page;
    }

    public void deleteById(String id) {
        Object[] ids = id.split(",");
        this.sqlHelper.deleteByIds((String[])ids, Upstream.class);
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().in("upstreamId", ids), UpstreamServer.class);
    }

    public void addOver(Upstream upstream, List<UpstreamServer> upstreamServers, String upstreamParamJson) {
        if (upstream.getProxyType() == 1 || upstream.getTactics() == null) {
            upstream.setTactics("");
        }
        this.sqlHelper.insertOrUpdate(upstream);
        List<Object> paramList = new ArrayList();
        if (StrUtil.isNotEmpty(upstreamParamJson) && JSONUtil.isTypeJSON(upstreamParamJson)) {
            paramList = JSONUtil.toList(JSONUtil.parseArray(upstreamParamJson), Param.class);
        }
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq("upstreamId", (Object)upstream.getId()), Param.class);
        Collections.reverse(paramList);
        for (Param param : paramList) {
            param.setUpstreamId(upstream.getId());
            this.sqlHelper.insert(param);
        }
        this.sqlHelper.deleteByQuery(new ConditionAndWrapper().eq("upstreamId", (Object)upstream.getId()), UpstreamServer.class);
        if (upstreamServers != null) {
            Collections.reverse(upstreamServers);
            for (UpstreamServer upstreamServer : upstreamServers) {
                upstreamServer.setUpstreamId(upstream.getId());
                this.sqlHelper.insert(upstreamServer);
            }
        }
    }

    public List<UpstreamServer> getUpstreamServers(String id) {
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("upstreamId", (Object)id), UpstreamServer.class);
    }

    public List<Upstream> getListByProxyType(Integer proxyType) {
        Sort sort = new Sort().add("seq", Sort.Direction.DESC);
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().eq("proxyType", (Object)proxyType), sort, Upstream.class);
    }

    public Long getCountByName(String name) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("name", (Object)name), Upstream.class);
    }

    public Long getCountByNameWithOutId(String name, String id) {
        return this.sqlHelper.findCountByQuery(new ConditionAndWrapper().eq("name", (Object)name).ne("id", (Object)id), Upstream.class);
    }

    public List<UpstreamServer> getServerListByMonitor(int monitor) {
        List<String> upstreamIds = this.sqlHelper.findIdsByQuery(new ConditionAndWrapper().eq("monitor", (Object)monitor), Upstream.class);
        return this.sqlHelper.findListByQuery(new ConditionAndWrapper().in("upstreamId", upstreamIds), UpstreamServer.class);
    }

    public List<UpstreamServer> getAllServer() {
        return this.sqlHelper.findAll(UpstreamServer.class);
    }

    public void resetMonitorStatus() {
        this.sqlHelper.updateMulti(new ConditionAndWrapper(), new Update().set("monitorStatus", -1), UpstreamServer.class);
    }

    public void setSeq(String upstreamId, Integer seqAdd) {
        Upstream upstream = this.sqlHelper.findById(upstreamId, Upstream.class);
        List<Upstream> upstreamList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.DESC), Upstream.class);
        if (upstreamList.size() > 0) {
            int i;
            Upstream tagert = null;
            if (seqAdd < 0) {
                for (i = 0; i < upstreamList.size(); ++i) {
                    if (upstreamList.get(i).getSeq() >= upstream.getSeq()) continue;
                    tagert = upstreamList.get(i);
                    break;
                }
            } else {
                for (i = upstreamList.size() - 1; i >= 0; --i) {
                    if (upstreamList.get(i).getSeq() <= upstream.getSeq()) continue;
                    tagert = upstreamList.get(i);
                    break;
                }
            }
            if (tagert != null) {
                Long seq = tagert.getSeq();
                tagert.setSeq(upstream.getSeq());
                upstream.setSeq(seq);
                this.sqlHelper.updateById(tagert);
                this.sqlHelper.updateById(upstream);
            }
        }
    }
}

