/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.bean;

import cn.hutool.core.util.StrUtil;
import com.cym.config.SQLConstants;
import com.cym.sqlhelper.bean.Order;
import com.cym.sqlhelper.reflection.ReflectionUtil;
import com.cym.sqlhelper.reflection.SerializableFunction;
import java.util.ArrayList;
import java.util.List;

public class Sort {
    List<Order> orderList = new ArrayList<Order>();

    public Sort() {
    }

    public Sort(String column, Direction direction) {
        Order order = new Order();
        order.setColumn(column);
        order.setDirection(direction);
        this.orderList.add(order);
    }

    public Sort(List<Order> orderList) {
        this.orderList.addAll(orderList);
    }

    public <T, R> Sort(SerializableFunction<T, R> column, Direction direction) {
        Order order = new Order();
        order.setColumn(ReflectionUtil.getFieldName(column));
        order.setDirection(direction);
        this.orderList.add(order);
    }

    public Sort add(String column, Direction direction) {
        Order order = new Order();
        order.setColumn(column);
        order.setDirection(direction);
        this.orderList.add(order);
        return this;
    }

    public <T, R> Sort add(SerializableFunction<T, R> column, Direction direction) {
        Order order = new Order();
        order.setColumn(ReflectionUtil.getFieldName(column));
        order.setDirection(direction);
        this.orderList.add(order);
        return this;
    }

    public String toString() {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Order order : this.orderList) {
            String sql = StrUtil.toUnderlineCase(order.getColumn());
            if (order.getColumn().equalsIgnoreCase("seq") || order.getColumn().equalsIgnoreCase("id")) {
                sql = "CAST(" + StrUtil.toUnderlineCase(order.getColumn()) + " as " + SQLConstants.ORDER_TYPE_INT + ")";
            }
            if (order.getDirection() == Direction.ASC) {
                sql = sql + " ASC";
            }
            if (order.getDirection() == Direction.DESC) {
                sql = sql + " DESC";
            }
            sqlList.add(sql);
        }
        return " ORDER BY " + StrUtil.join((CharSequence)",", sqlList);
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

