/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.config;

import com.cym.config.HomeConfig;
import com.cym.config.SQLConstants;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;

@Component
public class DataSourceEmbed {
    @Inject
    HomeConfig homeConfig;
    @Inject(value="${spring.database.type}")
    String databaseType;
    @Inject(value="${spring.datasource.url}")
    String url;
    @Inject(value="${spring.datasource.username}")
    String username;
    @Inject(value="${spring.datasource.password}")
    String password;
    HikariDataSource dataSource;

    @Init
    public void init() {
        if (this.databaseType.equalsIgnoreCase("sqlite")) {
            SQLConstants.SUFFIX = "`";
            SQLConstants.ORDER_TYPE_INT = "SIGNED";
            SQLConstants.LIMIT_SCRIPT = " LIMIT {offset},{limit}";
            HikariConfig dbConfig = new HikariConfig();
            dbConfig.setJdbcUrl("jdbc:sqlite:" + this.homeConfig.home + "sqlite.db");
            dbConfig.setUsername("");
            dbConfig.setPassword("");
            dbConfig.setMaximumPoolSize(1);
            dbConfig.setDriverClassName("org.sqlite.JDBC");
            this.dataSource = new HikariDataSource(dbConfig);
        } else if (this.databaseType.equalsIgnoreCase("mysql")) {
            SQLConstants.SUFFIX = "`";
            SQLConstants.ORDER_TYPE_INT = "SIGNED";
            SQLConstants.LIMIT_SCRIPT = " LIMIT {offset},{limit}";
            HikariConfig dbConfig = new HikariConfig();
            dbConfig.setJdbcUrl(this.url);
            dbConfig.setUsername(this.username);
            dbConfig.setPassword(this.password);
            dbConfig.setMaximumPoolSize(1);
            dbConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
            this.dataSource = new HikariDataSource(dbConfig);
        } else if (this.databaseType.equalsIgnoreCase("postgresql")) {
            SQLConstants.SUFFIX = "\"";
            SQLConstants.ORDER_TYPE_INT = "BIGINT";
            SQLConstants.LIMIT_SCRIPT = " LIMIT {limit} offset {offset}";
            HikariConfig dbConfig = new HikariConfig();
            dbConfig.setJdbcUrl(this.url);
            dbConfig.setUsername(this.username);
            dbConfig.setPassword(this.password);
            dbConfig.setMaximumPoolSize(1);
            dbConfig.setDriverClassName("org.postgresql.Driver");
            this.dataSource = new HikariDataSource(dbConfig);
        }
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }
}

