/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONUtil;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.config.Table;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class ImportOrExportUtil {
    @Inject
    private SqlHelper sqlHelper;
    @Inject(value="${project.beanPackage}")
    private String packageName;

    public void exportDb(String path) {
        path = path.replace(".zip", "");
        FileUtil.del(path);
        FileUtil.del(path + ".zip");
        try {
            Set<Class<?>> set = ClassUtil.scanPackage(this.packageName);
            Page page = new Page();
            page.setLimit(1000);
            for (Class<?> clazz : set) {
                try {
                    Table table = clazz.getAnnotation(Table.class);
                    if (table == null) continue;
                    page.setCurr(1);
                    while ((page = this.sqlHelper.findPage(page, clazz)).getRecords().size() != 0) {
                        ArrayList<String> lines = new ArrayList<String>();
                        for (Object object : page.getRecords()) {
                            lines.add(JSONUtil.toJsonStr(object));
                        }
                        FileUtil.appendLines(lines, path + File.separator + clazz.getSimpleName() + ".json", "UTF-8");
                        page.setCurr(page.getCurr() + 1);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ZipUtil.zip(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtil.del(path + ".zip");
        }
        FileUtil.del(path);
    }

    public void importDb(String path) {
        if (!FileUtil.exist(path)) {
            return;
        }
        BufferedReader reader = null;
        path = path.replace(".zip", "");
        FileUtil.del(path);
        ZipUtil.unzip(path + ".zip");
        try {
            Set<Class<?>> set = ClassUtil.scanPackage(this.packageName);
            for (Class<?> clazz : set) {
                File file;
                Table table = clazz.getAnnotation(Table.class);
                if (table == null || !(file = new File(path + File.separator + clazz.getSimpleName() + ".json")).exists()) continue;
                this.sqlHelper.deleteByQuery(new ConditionAndWrapper(), clazz);
                reader = FileUtil.getReader(file, StandardCharsets.UTF_8);
                ArrayList list = new ArrayList();
                while (true) {
                    String json;
                    if (StrUtil.isEmpty(json = reader.readLine())) break;
                    list.add(JSONUtil.toBean(json, clazz));
                    if (list.size() != 1000) continue;
                    this.sqlHelper.insertAll(list);
                    list.clear();
                }
                this.sqlHelper.insertAll(list);
                list.clear();
                IoUtil.close(reader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileUtil.del(path);
    }
}

