/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import com.cym.config.SQLConstants;
import com.cym.sqlhelper.config.DataSourceEmbed;
import com.cym.sqlhelper.utils.SnowFlake;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JdbcTemplate {
    @Inject
    DataSourceEmbed dataSourceEmbed;
    SnowFlake snowFlake = new SnowFlake(1L, 1L);
    static Logger logger = LoggerFactory.getLogger(JdbcTemplate.class);

    public List<Map<String, Object>> queryForList(String formatSql, Object ... array) {
        try {
            List<Entity> list = Db.use(this.dataSourceEmbed.getDataSource()).query(formatSql, array);
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            for (Entity entity : list) {
                HashMap map = new HashMap();
                for (Map.Entry entry : entity.entrySet()) {
                    map.put(entry.getKey().toString(), entry.getValue());
                }
                mapList.add(map);
            }
            return mapList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Set<String> queryForColumn(Class clazz) throws SQLException {
        HashSet<String> set = new HashSet();
        String uuid = this.snowFlake.nextId();
        Entity entity = new Entity();
        entity.setTableName(StrUtil.toUnderlineCase(clazz.getSimpleName()));
        entity.set("id", uuid);
        Db.use(this.dataSourceEmbed.getDataSource()).insert(entity);
        List<Entity> list = Db.use(this.dataSourceEmbed.getDataSource()).query("select * from " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " where id='" + uuid + "'", new Object[0]);
        for (Entity entityOne : list) {
            set = entityOne.getFieldNames();
        }
        Db.use(this.dataSourceEmbed.getDataSource()).del(entity);
        return set;
    }

    public Long queryForCount(String formatSql, Object ... array) {
        List<Map<String, Object>> list = this.queryForList(formatSql, array);
        if (list != null && list.size() != 0) {
            Map<String, Object> map = list.get(0);
            for (Map.Entry<String, Object> entity : map.entrySet()) {
                if (entity.getValue() instanceof Long) {
                    return (Long)entity.getValue();
                }
                if (entity.getValue() instanceof Integer) {
                    return ((Integer)entity.getValue()).longValue();
                }
                if (!(entity.getValue() instanceof Short)) continue;
                return ((Short)entity.getValue()).longValue();
            }
        }
        return 0L;
    }

    public void execute(String formatSql, Object ... array) {
        try {
            Db.use(this.dataSourceEmbed.getDataSource()).execute(formatSql, array);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
        }
    }
}

