/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.utils;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.config.SQLConstants;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.bean.Sort;
import com.cym.sqlhelper.bean.Update;
import com.cym.sqlhelper.config.InitValue;
import com.cym.sqlhelper.reflection.ReflectionUtil;
import com.cym.sqlhelper.reflection.SerializableFunction;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.ConditionWrapper;
import com.cym.sqlhelper.utils.JdbcTemplate;
import com.cym.sqlhelper.utils.SnowFlake;
import com.cym.sqlhelper.utils.SqlUtils;
import com.cym.sqlhelper.utils.TableUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SqlHelper
extends SqlUtils {
    @Inject(value="${project.beanPackage}")
    String packageName;
    @Inject
    JdbcTemplate jdbcTemplate;
    @Inject
    TableUtils tableUtils;
    static Logger logger = LoggerFactory.getLogger(SqlHelper.class);
    SnowFlake snowFlake = new SnowFlake(1L, 1L);

    @Init
    public void start() throws Throwable {
        Set<Class<?>> set = ClassUtil.scanPackage(this.packageName);
        for (Class<?> clazz : set) {
            this.tableUtils.initTable(clazz);
        }
    }

    public String insertOrUpdate(Object object) {
        Long time = System.currentTimeMillis();
        String id = (String)ReflectUtil.getFieldValue(object, "id");
        Object objectOrg = StrUtil.isNotEmpty(id) ? this.findById(id, object.getClass()) : null;
        try {
            if (objectOrg == null) {
                Field[] fields;
                if (ReflectUtil.getField(object.getClass(), "createTime") != null) {
                    ReflectUtil.setFieldValue(object, "createTime", (Object)time);
                }
                if (ReflectUtil.getField(object.getClass(), "updateTime") != null) {
                    ReflectUtil.setFieldValue(object, "updateTime", (Object)time);
                }
                this.setDefaultVaule(object);
                ReflectUtil.setFieldValue(object, "id", (Object)this.snowFlake.nextId());
                String sql = "";
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<String> placeHolder = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                    fieldsPart.add(SQLConstants.SUFFIX + StrUtil.toUnderlineCase(field.getName()) + SQLConstants.SUFFIX);
                    placeHolder.add("?");
                    paramValues.add(ReflectUtil.getFieldValue(object, field));
                }
                sql = "INSERT INTO " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(object.getClass().getSimpleName()) + SQLConstants.SUFFIX + " (" + StrUtil.join((CharSequence)",", fieldsPart) + ") VALUES (" + StrUtil.join((CharSequence)",", placeHolder) + ")";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.execute(this.formatSql(sql), paramValues.toArray());
            } else {
                Field[] fields = ReflectUtil.getFields(object.getClass());
                if (ReflectUtil.getField(object.getClass(), "updateTime") != null) {
                    ReflectUtil.setFieldValue(object, "updateTime", (Object)time);
                }
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields) {
                    if (field.getName().equals("id") || ReflectUtil.getFieldValue(object, field) == null) continue;
                    fieldsPart.add(SQLConstants.SUFFIX + StrUtil.toUnderlineCase(field.getName()) + SQLConstants.SUFFIX + "=?");
                    paramValues.add(ReflectUtil.getFieldValue(object, field));
                }
                paramValues.add(id);
                String sql = "UPDATE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(object.getClass().getSimpleName()) + SQLConstants.SUFFIX + " SET " + StrUtil.join((CharSequence)",", fieldsPart) + " WHERE id = ?";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.execute(this.formatSql(sql), paramValues.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return (String)ReflectUtil.getFieldValue(object, "id");
    }

    public String insert(Object object) {
        Object objectOrg;
        String id = (String)ReflectUtil.getFieldValue(object, "id");
        Object v0 = objectOrg = StrUtil.isNotEmpty(id) ? this.findById(id, object.getClass()) : null;
        if (objectOrg != null) {
            ReflectUtil.setFieldValue(object, "id", (Object)this.snowFlake.nextId());
        }
        if (ReflectUtil.getFieldValue(object, "id") == null) {
            ReflectUtil.setFieldValue(object, "id", (Object)this.snowFlake.nextId());
        }
        this.insertOrUpdate(object);
        return (String)ReflectUtil.getFieldValue(object, "id");
    }

    public <T> void insertAll(List<T> list) {
        Long time = System.currentTimeMillis();
        HashMap idMap = new HashMap();
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, "id") == null) continue;
            String id = (String)ReflectUtil.getFieldValue(object, "id");
            Object objectOrg = StrUtil.isNotEmpty(id) ? (Object)this.findById(id, object.getClass()) : null;
            idMap.put((String)ReflectUtil.getFieldValue(object, "id"), objectOrg);
        }
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, "id") != null && idMap.get((String)ReflectUtil.getFieldValue(object, "id")) != null) {
                ReflectUtil.setFieldValue(object, "id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getFieldValue(object, "id") == null) {
                ReflectUtil.setFieldValue(object, "id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getField(object.getClass(), "createTime") != null) {
                ReflectUtil.setFieldValue(object, "createTime", (Object)time);
            }
            if (ReflectUtil.getField(object.getClass(), "updateTime") != null) {
                ReflectUtil.setFieldValue(object, "updateTime", (Object)time);
            }
            this.setDefaultVaule(object);
        }
        String sqls = null;
        for (T object : list) {
            Field[] fields = ReflectUtil.getFields(object.getClass());
            ArrayList<String> fieldsPart = new ArrayList<String>();
            ArrayList<String> placeHolder = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            for (Field field : fields) {
                fieldsPart.add(SQLConstants.SUFFIX + StrUtil.toUnderlineCase(field.getName()) + SQLConstants.SUFFIX);
                placeHolder.add("?");
                params.add(ReflectUtil.getFieldValue(object, field));
            }
            if (sqls == null) {
                sqls = "INSERT INTO " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(object.getClass().getSimpleName()) + SQLConstants.SUFFIX + " (" + StrUtil.join((CharSequence)",", fieldsPart) + ") VALUES (" + StrUtil.join((CharSequence)",", placeHolder) + ")";
            }
            this.jdbcTemplate.execute(this.formatSql(sqls), params.toArray());
        }
    }

    public void updateById(Object object) {
        if (StrUtil.isEmpty((String)ReflectUtil.getFieldValue(object, "id"))) {
            return;
        }
        this.insertOrUpdate(object);
    }

    public void updateMulti(ConditionWrapper conditionWrapper, Update update, Class<?> clazz) {
        if (update == null || update.getSets().size() == 0) {
            return;
        }
        ArrayList<String> fieldsPart = new ArrayList<String>();
        ArrayList<String> paramValues = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : update.getSets().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            fieldsPart.add(SQLConstants.SUFFIX + StrUtil.toUnderlineCase(entry.getKey()) + SQLConstants.SUFFIX + "=?");
            paramValues.add(entry.getValue().toString());
        }
        String sql = "UPDATE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " SET " + StrUtil.join((CharSequence)",", fieldsPart);
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(paramValues);
        }
        this.logQuery(this.formatSql(sql), paramValues.toArray());
        this.jdbcTemplate.execute(this.formatSql(sql), paramValues.toArray());
    }

    public void addCountById(String id, String property, Long count, Class<?> clazz) {
        String sql = "UPDATE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " SET " + SQLConstants.SUFFIX + property + SQLConstants.SUFFIX + " = CAST(" + SQLConstants.SUFFIX + property + SQLConstants.SUFFIX + " AS DECIMAL(30,10)) + ? WHERE id =  ?";
        Object[] params = new Object[]{count, id};
        this.logQuery(this.formatSql(sql), params);
        this.jdbcTemplate.execute(this.formatSql(sql), params);
    }

    public <T, R> void addCountById(String id, SerializableFunction<T, R> property, Long count, Class<?> clazz) {
        this.addCountById(id, ReflectionUtil.getFieldName(property), count, clazz);
    }

    public void updateAllColumnById(Object object) {
        if (StrUtil.isEmpty((String)ReflectUtil.getFieldValue(object, "id"))) {
            return;
        }
        Field[] fields = ReflectUtil.getFields(object.getClass());
        ArrayList<String> fieldsPart = new ArrayList<String>();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (Field field : fields) {
            if (field.getName().equals("id")) continue;
            fieldsPart.add(SQLConstants.SUFFIX + StrUtil.toUnderlineCase(field.getName()) + SQLConstants.SUFFIX + "=?");
            paramValues.add(ReflectUtil.getFieldValue(object, field));
        }
        paramValues.add(ReflectUtil.getFieldValue(object, "id"));
        String sql = "UPDATE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(object.getClass().getSimpleName()) + SQLConstants.SUFFIX + " SET " + StrUtil.join((CharSequence)",", fieldsPart) + " WHERE id = ?";
        this.logQuery(this.formatSql(sql), paramValues.toArray());
        this.jdbcTemplate.execute(this.formatSql(sql), paramValues.toArray());
    }

    public void deleteById(String id, Class<?> clazz) {
        if (StrUtil.isEmpty(id)) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().eq("id", (Object)id), clazz);
    }

    public void deleteByIds(Collection<String> ids, Class<?> clazz) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().in("id", (Collection)ids), clazz);
    }

    public void deleteByIds(String[] ids, Class<?> clazz) {
        this.deleteByIds(Arrays.asList(ids), clazz);
    }

    public void deleteByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "DELETE FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX;
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        this.jdbcTemplate.execute(this.formatSql(sql), values.toArray());
    }

    private void setDefaultVaule(Object object) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(InitValue.class)) continue;
            InitValue defaultValue = field.getAnnotation(InitValue.class);
            String value = defaultValue.value();
            if (ReflectUtil.getFieldValue(object, field) != null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)value);
            }
            if (type.equals(Short.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)Short.parseShort(value));
            }
            if (type.equals(Integer.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)Integer.parseInt(value));
            }
            if (type.equals(Long.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)Long.parseLong(value));
            }
            if (type.equals(Float.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)Float.valueOf(Float.parseFloat(value)));
            }
            if (type.equals(Double.class)) {
                ReflectUtil.setFieldValue(object, field, (Object)Double.parseDouble(value));
            }
            if (!type.equals(Boolean.class)) continue;
            ReflectUtil.setFieldValue(object, field, (Object)Boolean.parseBoolean(value));
        }
    }

    public Page findPage(ConditionWrapper conditionWrapper, Sort sort, Page page, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        Long count = this.findCountByQuery(conditionWrapper, clazz);
        String sql = "SELECT * FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX;
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY CAST(id AS " + SQLConstants.ORDER_TYPE_INT + ") DESC";
        sql = sql + SQLConstants.cutPage(page.getCurr(), page.getLimit());
        page.setCount(count);
        this.logQuery(this.formatSql(sql), values.toArray());
        page.setRecords(this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz));
        return page;
    }

    public Page findPage(Sort sort, Page page, Class<?> clazz) {
        return this.findPage(null, sort, page, clazz);
    }

    public Page findPage(ConditionWrapper conditionWrapper, Page page, Class<?> clazz) {
        return this.findPage(conditionWrapper, null, page, clazz);
    }

    public Page findPage(Page page, Class<?> clazz) {
        return this.findPage(null, null, page, clazz);
    }

    public <T> T findById(String id, Class<T> clazz) {
        if (StrUtil.isEmpty(id)) {
            return null;
        }
        return this.findOneByQuery(new ConditionAndWrapper().eq("id", (Object)id), clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        List<Object> list = new ArrayList();
        String sql = "SELECT * FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX;
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY CAST(id AS " + SQLConstants.ORDER_TYPE_INT + ") DESC";
        sql = sql + " limit 1";
        this.logQuery(this.formatSql(sql), values.toArray());
        list = this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
        return (T)(list.size() > 0 ? list.get(0) : null);
    }

    public <T> T findOneByQuery(Sort sort, Class<T> clazz) {
        return this.findOneByQuery(null, sort, clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findOneByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "SELECT * FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX;
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY CAST(id AS " + SQLConstants.ORDER_TYPE_INT + ") DESC";
        this.logQuery(this.formatSql(sql), values.toArray());
        return this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findListByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public <T> List<T> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property, Class<T> propertyClass) {
        List<?> list = this.findListByQuery(conditionWrapper, documentClass);
        List<T> propertyList = this.extractProperty(list, property, propertyClass);
        return propertyList;
    }

    public <T, R> List<T> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, SerializableFunction<T, R> property, Class<T> propertyClass) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, ReflectionUtil.getFieldName(property), propertyClass);
    }

    public List<String> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, property, String.class);
    }

    public <T, R> List<String> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, ReflectionUtil.getFieldName(property), String.class);
    }

    public List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, String property) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<String>();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findPropertiesByQuery((ConditionWrapper)ConditionAndWrapper2, documentClass, property, String.class);
    }

    public <T, R> List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByIds(ids, documentClass, ReflectionUtil.getFieldName(property));
    }

    public List<String> findPropertiesByIds(String[] ids, Class<?> documentClass, String property) {
        return this.findPropertiesByIds(Arrays.asList(ids), documentClass, property);
    }

    public <T, R> List<String> findPropertiesByIds(String[] ids, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByIds(Arrays.asList(ids), documentClass, ReflectionUtil.getFieldName(property));
    }

    public List<String> findIdsByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        return this.findPropertiesByQuery(conditionWrapper, clazz, "id");
    }

    public <T> List<T> findListByIds(Collection<String> ids, Class<T> clazz) {
        return this.findListByIds(ids, null, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), null, clazz);
    }

    public <T> List<T> findListByIds(Collection<String> ids, Sort sort, Class<T> clazz) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findListByQuery(ConditionAndWrapper2, sort, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Sort sort, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), sort, clazz);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findAll(null, clazz);
    }

    public <T> List<T> findAll(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public List<String> findAllIds(Class<?> clazz) {
        return this.findIdsByQuery(null, clazz);
    }

    public Long findCountByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "SELECT COUNT(*) FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX;
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        return this.jdbcTemplate.queryForCount(this.formatSql(sql), values.toArray());
    }

    public Long findAllCount(Class<?> clazz) {
        return this.findCountByQuery(null, clazz);
    }

    private <T> List<T> extractProperty(List<?> list, String property, Class<T> clazz) {
        HashSet<Object> rs = new HashSet<Object>();
        for (Object object : list) {
            Object value = ReflectUtil.getFieldValue(object, property);
            if (value == null || !value.getClass().equals(clazz)) continue;
            rs.add(value);
        }
        return new ArrayList(rs);
    }

    public <T> List<T> buildObjects(List<Map<String, Object>> queryForList, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Field[] fields = ReflectUtil.getFields(clazz);
            for (Map<String, Object> map : queryForList) {
                T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                block3: for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    for (Field field : fields) {
                        if (!StrUtil.toUnderlineCase(field.getName()).equals(mapKey)) continue;
                        ReflectUtil.setFieldValue(obj, field.getName(), mapValue);
                        continue block3;
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

