/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.utils;

import cn.hutool.core.util.StrUtil;
import com.cym.config.SQLConstants;
import com.cym.sqlhelper.utils.JdbcTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SqlUtils {
    static Logger logger = LoggerFactory.getLogger(SqlUtils.class);
    @Inject(value="${project.sqlPrint:false}")
    Boolean print;
    @Inject
    JdbcTemplate jdbcTemplate;
    String separator = System.getProperty("line.separator");

    public String formatSql(String sql) {
        if (StrUtil.isEmpty(sql)) {
            return "";
        }
        sql = sql.replace("FROM", this.separator + "FROM").replace("WHERE", this.separator + "WHERE").replace("ORDER", this.separator + "ORDER").replace("LIMIT", this.separator + "LIMIT").replace("VALUES", this.separator + "VALUES");
        return sql;
    }

    public void checkOrCreateTable(Class<?> clazz) {
        String sql = "CREATE TABLE IF NOT EXISTS " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " (id VARCHAR(32) NOT NULL PRIMARY KEY)";
        this.logQuery(this.formatSql(sql));
        this.jdbcTemplate.execute(this.formatSql(sql), new Object[0]);
    }

    public void logQuery(String sql) {
        this.logQuery(sql, null);
    }

    public void logQuery(String sql, Object[] params) {
        if (this.print.booleanValue()) {
            try {
                if (params != null) {
                    for (Object object : params) {
                        if (object instanceof String) {
                            object = object.toString().replace("$", "RDS_CHAR_DOLLAR");
                            sql = sql.replaceFirst("\\?", "'" + object + "'").replace("RDS_CHAR_DOLLAR", "$");
                            continue;
                        }
                        sql = sql.replaceFirst("\\?", String.valueOf(object));
                    }
                }
                logger.info(sql);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public void checkOrCreateIndex(Class<?> clazz, String name, boolean unique, List<Map<String, Object>> indexs) {
        this.checkOrCreateIndex(clazz, new String[]{name}, unique, indexs);
    }

    public void checkOrCreateIndex(Class<?> clazz, String[] colums, boolean unique, List<Map<String, Object>> indexs) {
        ArrayList<String> columList = new ArrayList<String>();
        for (String colum : colums) {
            columList.add(StrUtil.toUnderlineCase(colum));
        }
        String name = StrUtil.join((CharSequence)"&", columList) + "@" + StrUtil.toUnderlineCase(clazz.getSimpleName());
        boolean hasIndex = false;
        for (Map<String, Object> map : indexs) {
            if (!StrUtil.toUnderlineCase(name).equalsIgnoreCase((String)map.get("name")) && !StrUtil.toUnderlineCase(name).equalsIgnoreCase((String)map.get("Key_name"))) continue;
            hasIndex = true;
        }
        if (!hasIndex) {
            String type = unique ? "UNIQUE INDEX" : "INDEX";
            String length = "";
            columList = new ArrayList();
            for (String colum : colums) {
                columList.add(StrUtil.toUnderlineCase(SQLConstants.SUFFIX + colum + SQLConstants.SUFFIX + length));
            }
            String sql = "CREATE " + type + "  " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(name) + SQLConstants.SUFFIX + " ON " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + "(" + StrUtil.join((CharSequence)",", columList) + ")";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql), new Object[0]);
        }
    }

    public void checkOrCreateColumn(Class<?> clazz, String name, Set<String> columns) {
        if (!columns.contains(StrUtil.toUnderlineCase(name).toLowerCase())) {
            String sql = "ALTER TABLE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " ADD COLUMN " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(name) + SQLConstants.SUFFIX + " TEXT";
            this.logQuery(this.formatSql(sql));
            logger.debug("checkOrCreateColumn sql:{} ", (Object)this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql), new Object[0]);
        }
    }

    public void updateDefaultValue(Class<?> clazz, String column, String value) {
        String sql = "SELECT COUNT(*) FROM " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " WHERE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(column) + SQLConstants.SUFFIX + " IS NULL";
        this.logQuery(this.formatSql(sql));
        logger.debug("updateDefaultValue sql:{} ", (Object)this.formatSql(sql));
        Long count = this.jdbcTemplate.queryForCount(this.formatSql(sql), new Object[0]);
        if (count != null && count > 0L) {
            sql = "UPDATE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(clazz.getSimpleName()) + SQLConstants.SUFFIX + " SET " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(column) + SQLConstants.SUFFIX + " = ? WHERE " + SQLConstants.SUFFIX + StrUtil.toUnderlineCase(column) + SQLConstants.SUFFIX + " IS NULL";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql), value);
        }
    }
}

