/*
 * Decompiled with CFR 0.152.
 */
package com.cym.sqlhelper.utils;

import cn.hutool.core.util.ReflectUtil;
import com.cym.sqlhelper.config.InitValue;
import com.cym.sqlhelper.config.Table;
import com.cym.sqlhelper.utils.JdbcTemplate;
import com.cym.sqlhelper.utils.SqlUtils;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Set;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TableUtils {
    static Logger logger = LoggerFactory.getLogger(TableUtils.class);
    @Inject
    JdbcTemplate jdbcTemplate;
    @Inject
    SqlUtils sqlUtils;

    public void initTable(Class<?> clazz) throws SQLException {
        Table table = clazz.getAnnotation(Table.class);
        if (table != null) {
            Field[] fields;
            this.sqlUtils.checkOrCreateTable(clazz);
            Set<String> columns = this.jdbcTemplate.queryForColumn(clazz);
            for (Field field : fields = ReflectUtil.getFields(clazz)) {
                InitValue defaultValue;
                if (!field.getName().equals("id")) {
                    this.sqlUtils.checkOrCreateColumn(clazz, field.getName(), columns);
                }
                if (!field.isAnnotationPresent(InitValue.class) || (defaultValue = field.getAnnotation(InitValue.class)).value() == null) continue;
                this.sqlUtils.updateDefaultValue(clazz, field.getName(), defaultValue.value());
            }
        }
    }
}

