/*
 * Decompiled with CFR 0.152.
 */
package com.cym.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.config.HomeConfig;
import com.cym.controller.adminPage.CertController;
import com.cym.controller.adminPage.ConfController;
import com.cym.controller.adminPage.RemoteController;
import com.cym.model.Cert;
import com.cym.model.Remote;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.HttpService;
import com.cym.service.LogService;
import com.cym.service.RemoteService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.sqlhelper.utils.ConditionAndWrapper;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.BLogFileTailer;
import com.cym.utils.MessageUtils;
import com.cym.utils.SendMailUtils;
import com.cym.utils.TelnetUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ScheduleTask {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject(value="${server.port}")
    Integer port;
    @Inject(value="${solon.logging.appender.file.maxHistory}")
    Integer maxHistory;
    @Inject
    SqlHelper sqlHelper;
    @Inject
    CertController certController;
    @Inject
    SettingService settingService;
    @Inject
    ConfController confController;
    @Inject
    RemoteController remoteController;
    @Inject
    RemoteService remoteService;
    @Inject
    UpstreamService upstreamService;
    @Inject
    LogService logInfoService;
    @Inject
    SendMailUtils sendMailUtils;
    @Inject
    HttpService httpService;
    @Inject
    MessageUtils m;
    @Inject
    HomeConfig homeConfig;
    @Inject
    BLogFileTailer bLogFileTailer;

    @Scheduled(cron="0 0 0/2 * * ?")
    public void certTasks() {
        List<Cert> certList = this.sqlHelper.findListByQuery(new ConditionAndWrapper().in(Cert::getType, (Object[])new Integer[]{0, 2}), Cert.class);
        long time = System.currentTimeMillis();
        for (Cert cert : certList) {
            if (cert.getMakeTime() == null || cert.getAutoRenew() != 1 || time - cert.getMakeTime() <= TimeUnit.DAYS.toMillis(60L)) continue;
            this.certController.apply(cert.getId(), "renew");
        }
    }

    @Scheduled(cron="0/30 * * * * ?")
    public void nginxTasks() {
        String lastNginxSend = this.settingService.get("lastNginxSend");
        String mail = this.settingService.get("mail");
        String nginxMonitor = this.settingService.get("nginxMonitor");
        String mailInterval = this.settingService.get("mail_interval");
        if (StrUtil.isEmpty(mailInterval)) {
            mailInterval = "30";
        }
        if ("true".equals(nginxMonitor) && StrUtil.isNotEmpty(mail) && (StrUtil.isEmpty(lastNginxSend) || System.currentTimeMillis() - Long.parseLong(lastNginxSend) > TimeUnit.MINUTES.toMillis(Integer.parseInt(mailInterval)))) {
            Map<String, Object> map;
            ArrayList<String> names = new ArrayList<String>();
            List<Remote> remoteList = this.remoteService.getMonitorRemoteList();
            for (Remote remote : remoteList) {
                try {
                    String json = HttpUtil.get(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/version?creditKey=" + remote.getCreditKey(), 1000);
                    Map map2 = (Map)JSONUtil.toBean(json, new TypeReference<Map<String, Object>>(){}.getType(), false);
                    if ((Integer)map2.get("nginx") != 0 || remote.getMonitor() != 1) continue;
                    names.add(remote.getDescr() + "[" + remote.getIp() + ":" + remote.getPort() + "]");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                    names.add(remote.getDescr() + "[" + remote.getIp() + ":" + remote.getPort() + "]");
                }
            }
            if ("1".equals(this.settingService.get("monitorLocal")) && (Integer)(map = this.remoteController.version()).get("nginx") == 0) {
                names.add(0, this.m.get("remoteStr.local") + "[127.0.0.1:" + this.port + "]");
            }
            if (names.size() > 0) {
                this.sendMailUtils.sendMailSmtp(mail, this.m.get("mailStr.nginxFail"), this.m.get("mailStr.nginxTips") + StrUtil.join((CharSequence)" ", names));
                this.settingService.set("lastNginxSend", String.valueOf(System.currentTimeMillis()));
            }
        }
    }

    @Scheduled(cron="0/30 * * * * ?")
    public void nodeTasks() {
        String lastUpstreamSend = this.settingService.get("lastUpstreamSend");
        String mail = this.settingService.get("mail");
        String upstreamMonitor = this.settingService.get("upstreamMonitor");
        String mailInterval = this.settingService.get("mail_interval");
        if (StrUtil.isEmpty(mailInterval)) {
            mailInterval = "30";
        }
        if ("true".equals(upstreamMonitor)) {
            List<UpstreamServer> upstreamServers = this.upstreamService.getAllServer();
            ArrayList<String> ips = new ArrayList<String>();
            for (UpstreamServer upstreamServer : upstreamServers) {
                if (!TelnetUtils.isRunning(upstreamServer.getServer(), upstreamServer.getPort())) {
                    Upstream upstream = this.sqlHelper.findById(upstreamServer.getUpstreamId(), Upstream.class);
                    if (upstream.getMonitor() == 1 && StrUtil.isNotEmpty(mail) && (StrUtil.isEmpty(lastUpstreamSend) || System.currentTimeMillis() - Long.parseLong(lastUpstreamSend) > TimeUnit.MINUTES.toMillis(Integer.parseInt(mailInterval)))) {
                        ips.add(upstreamServer.getServer() + ":" + upstreamServer.getPort());
                    }
                    upstreamServer.setMonitorStatus(0);
                } else {
                    upstreamServer.setMonitorStatus(1);
                }
                this.sqlHelper.updateById(upstreamServer);
            }
            if (ips.size() > 0) {
                String dateStr = DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss");
                if (this.settingService.get("lang") != null && this.settingService.get("lang").equals("en_US")) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.ENGLISH);
                    dateStr = dateFormat.format(new Date());
                }
                this.sendMailUtils.sendMailSmtp(mail, this.m.get("mailStr.upstreamFail"), this.m.get("mailStr.upstreamTips") + StrUtil.join((CharSequence)" ", ips) + "\r\n" + dateStr);
                this.settingService.set("lastUpstreamSend", String.valueOf(System.currentTimeMillis()));
            }
        }
    }
}

