/*
 * Decompiled with CFR 0.152.
 */
package com.cym.utils;

import cn.hutool.core.util.StrUtil;
import com.cym.config.HomeConfig;
import com.cym.model.Admin;
import com.cym.service.AdminService;
import com.cym.sqlhelper.bean.Page;
import com.cym.sqlhelper.utils.SqlHelper;
import com.cym.utils.JsonResult;
import com.cym.utils.MessageUtils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.handle.Context;

public class BaseController {
    @Inject
    protected SqlHelper sqlHelper;
    @Inject
    protected AdminService adminService;
    @Inject
    protected MessageUtils m;
    @Inject
    protected HomeConfig homeConfig;

    protected JsonResult renderError() {
        JsonResult result = new JsonResult();
        result.setSuccess(false);
        result.setStatus("500");
        return result;
    }

    protected JsonResult renderAuthError() {
        JsonResult result = new JsonResult();
        result.setSuccess(false);
        result.setStatus("401");
        return result;
    }

    protected JsonResult renderError(String msg) {
        JsonResult result = this.renderError();
        result.setMsg(msg);
        return result;
    }

    protected JsonResult renderSuccess() {
        JsonResult result = new JsonResult();
        result.setSuccess(true);
        result.setStatus("200");
        return result;
    }

    protected JsonResult renderSuccess(Object obj) {
        JsonResult result = this.renderSuccess();
        result.setObj(obj);
        return result;
    }

    public void setPage(Page page) {
        String limit = (String)Context.current().session("limit");
        if (StrUtil.isNotEmpty(limit)) {
            page.setLimit(Integer.parseInt(limit));
        }
    }

    public Admin getAdmin() {
        Admin admin = (Admin)Context.current().session("admin");
        if (admin == null) {
            String token = Context.current().header("token");
            admin = this.adminService.getByToken(token);
        }
        if (admin == null) {
            String creditKey = Context.current().param("creditKey");
            admin = this.adminService.getByCreditKey(creditKey);
        }
        return admin;
    }
}

