/*
 * Decompiled with CFR 0.152.
 */
package com.cym.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FilePermissionUtil {
    public static Boolean canRead(File file) {
        if (file.isDirectory()) {
            try {
                File[] listFiles = file.listFiles();
                if (listFiles == null) {
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!file.exists()) {
            return false;
        }
        return FilePermissionUtil.checkRead(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkRead(File file) {
        FileReader fd = null;
        try {
            fd = new FileReader(file);
            if (fd.read() != -1) {
                // empty if block
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Boolean canWrite(File file) {
        if (file.isDirectory()) {
            try {
                file = new File(file, "canWriteTestDeleteOnExit.temp");
                if (file.exists()) {
                    boolean checkWrite = FilePermissionUtil.checkWrite(file);
                    if (!FilePermissionUtil.deleteFile(file)) {
                        file.deleteOnExit();
                    }
                    return checkWrite;
                }
                if (file.createNewFile()) {
                    if (!FilePermissionUtil.deleteFile(file)) {
                        file.deleteOnExit();
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return FilePermissionUtil.checkWrite(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkWrite(File file) {
        FileWriter fw = null;
        boolean delete = !file.exists();
        boolean result = false;
        try {
            fw = new FileWriter(file, true);
            fw.write("");
            fw.flush();
            boolean bl = result = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (delete && result) {
                FilePermissionUtil.deleteFile(file);
            }
        }
    }

    public static boolean deleteFile(File file) {
        return FilePermissionUtil.deleteFile(file, true);
    }

    public static boolean deleteFile(File file, boolean delDir) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        boolean result = true;
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; ++i) {
            result = FilePermissionUtil.deleteFile(children[i], delDir);
            if (result) continue;
            return false;
        }
        if (delDir) {
            result = file.delete();
        }
        return result;
    }
}

