/*
 * Decompiled with CFR 0.152.
 */
package com.cym.utils;

import cn.hutool.core.util.StrUtil;
import com.cym.service.SettingService;
import com.cym.utils.PropertiesUtils;
import java.util.Properties;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;

@Component
public class MessageUtils {
    @Inject
    PropertiesUtils propertiesUtils;
    Properties properties = null;
    Properties propertiesEN = null;
    Properties propertiesTW = null;
    @Inject
    SettingService settingService;

    @Init
    public void afterInjection() {
        this.propertiesTW = this.propertiesUtils.getPropertis("messages_zh_TW.properties");
        this.propertiesEN = this.propertiesUtils.getPropertis("messages_en_US.properties");
        this.properties = this.propertiesUtils.getPropertis("messages.properties");
    }

    public String get(String msgKey) {
        String lang = this.settingService.get("lang");
        if (StrUtil.isEmpty(lang)) {
            return this.properties.getProperty(msgKey);
        }
        if ("en_US".equals(lang)) {
            return this.propertiesEN.getProperty(msgKey);
        }
        if ("zh_TW".equals(lang)) {
            return this.propertiesTW.getProperty(msgKey);
        }
        return "";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getPropertiesEN() {
        return this.propertiesEN;
    }

    public void setPropertiesEN(Properties propertiesEN) {
        this.propertiesEN = propertiesEN;
    }

    public PropertiesUtils getPropertiesUtils() {
        return this.propertiesUtils;
    }

    public void setPropertiesUtils(PropertiesUtils propertiesUtils) {
        this.propertiesUtils = propertiesUtils;
    }

    public Properties getPropertiesTW() {
        return this.propertiesTW;
    }

    public void setPropertiesTW(Properties propertiesTW) {
        this.propertiesTW = propertiesTW;
    }

    public SettingService getSettingService() {
        return this.settingService;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }
}

