/*
 * Decompiled with CFR 0.152.
 */
package com.cym.utils;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.utils.oshi.CpuDomain;
import com.cym.utils.oshi.DiskDomain;
import com.cym.utils.oshi.MemoryDomain;
import com.cym.utils.oshi.NetDomain;
import com.cym.utils.oshi.ServerDomain;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.GlobalConfig;

public final class OshiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OshiUtils.class);
    public static final SystemInfo SYSTEM_INFO = OshiUtils.initOshi();
    private static final String TYPE_NAME = "local";

    private static SystemInfo initOshi() {
        GlobalConfig.set("oshi.os.windows.loadaverage", true);
        return new SystemInfo();
    }

    public static ServerDomain getOshiServerInfo() {
        ServerDomain serverDomain = new ServerDomain();
        serverDomain.setCpuDomain(OshiUtils.getCpuInfo());
        serverDomain.setMemoryDomain(OshiUtils.getMemoryInfo());
        serverDomain.setNetDomain(OshiUtils.getNetInfo());
        serverDomain.setDiskDomain(OshiUtils.getDiskInfo());
        return serverDomain;
    }

    public static void main(String[] args) {
        ServerDomain serverDomain = OshiUtils.getOshiServerInfo();
    }

    public static CpuDomain getCpuInfo() {
        try {
            CentralProcessor processor = SYSTEM_INFO.getHardware().getProcessor();
            CentralProcessor.ProcessorIdentifier processorIdentifier = processor.getProcessorIdentifier();
            String model = processorIdentifier.getName();
            String vendor = processorIdentifier.getVendor();
            int logicalProcessorCount = processor.getLogicalProcessorCount();
            long[] currentFreq = processor.getCurrentFreq();
            long[][] prevTicks = processor.getProcessorCpuLoadTicks();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff01", e);
            }
            long[][] ticks = processor.getProcessorCpuLoadTicks();
            CpuDomain cpuDomain = new CpuDomain();
            ArrayList<CpuDomain.CpuInfoDomain> cpuInfoDomains = new ArrayList<CpuDomain.CpuInfoDomain>();
            for (int cpu = 0; cpu < logicalProcessorCount; ++cpu) {
                long user = ticks[cpu][CentralProcessor.TickType.USER.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.USER.getIndex()];
                long nice = ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.NICE.getIndex()];
                long sys = ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()];
                long idle = ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()];
                long iowait = ticks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()];
                long irq = ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.IRQ.getIndex()];
                long softirq = ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()];
                long steal = ticks[cpu][CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[cpu][CentralProcessor.TickType.STEAL.getIndex()];
                long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
                CpuDomain.CpuInfoDomain cpuInfoDomain = new CpuDomain.CpuInfoDomain();
                cpuInfoDomain.setCpuMhz((int)(currentFreq[cpu] / 1000000L));
                cpuInfoDomain.setCpuModel(model);
                cpuInfoDomain.setCpuVendor(vendor);
                cpuInfoDomain.setCpuUser((double)user / (double)totalCpu);
                cpuInfoDomain.setCpuSys((double)sys / (double)totalCpu);
                cpuInfoDomain.setCpuWait((double)iowait / (double)totalCpu);
                cpuInfoDomain.setCpuNice((double)nice / (double)totalCpu);
                cpuInfoDomain.setCpuIdle((double)idle / (double)totalCpu);
                cpuInfoDomain.setCpuCombined((double)(user + sys) / (double)totalCpu);
                cpuInfoDomains.add(cpuInfoDomain);
            }
            cpuDomain.setCpuNum(logicalProcessorCount);
            cpuDomain.setCpuList(cpuInfoDomains);
            return cpuDomain;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public static MemoryDomain getMemoryInfo() {
        try {
            GlobalMemory memory = SYSTEM_INFO.getHardware().getMemory();
            long memoryTotal = memory.getTotal();
            long memFree = memory.getAvailable();
            long memUsed = memoryTotal - memFree;
            MemoryDomain.MenDomain menDomain = new MemoryDomain.MenDomain();
            menDomain.setMemTotal(memoryTotal);
            menDomain.setMemUsed(memUsed);
            menDomain.setMemFree(memFree);
            menDomain.setMenUsedPercent(NumberUtil.round((double)memUsed / (double)memoryTotal, 4).doubleValue());
            VirtualMemory virtualMemory = memory.getVirtualMemory();
            long swapTotal = virtualMemory.getSwapTotal();
            long swapUsed = virtualMemory.getSwapUsed();
            long swapFree = swapTotal - swapUsed;
            MemoryDomain.SwapDomain swapDomain = new MemoryDomain.SwapDomain();
            swapDomain.setSwapTotal(swapTotal);
            swapDomain.setSwapUsed(swapUsed);
            swapDomain.setSwapFree(swapFree);
            swapDomain.setSwapUsedPercent(swapTotal == 0L ? 0.0 : NumberUtil.round((double)swapUsed / (double)swapTotal, 4).doubleValue());
            MemoryDomain memoryDomain = new MemoryDomain();
            memoryDomain.setMenDomain(menDomain);
            memoryDomain.setSwapDomain(swapDomain);
            return memoryDomain;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public static NetDomain getNetInfo() {
        try {
            NetDomain netDomain = new NetDomain();
            ArrayList<NetDomain.NetInterfaceDomain> netInterfaceConfigDomains = new ArrayList<NetDomain.NetInterfaceDomain>();
            List<NetworkIF> networkIfsEnd = SYSTEM_INFO.getHardware().getNetworkIFs(true);
            for (NetworkIF net : networkIfsEnd) {
                String netName;
                String macAddr;
                NetDomain.NetInterfaceDomain netInterfaceDomain = new NetDomain.NetInterfaceDomain();
                String[] iPv4addr = net.getIPv4addr();
                if (OshiUtils.ignore(iPv4addr, macAddr = net.getMacaddr().toUpperCase(), netName = net.getName())) continue;
                long start = System.currentTimeMillis();
                long rxBytesStart = net.getBytesRecv();
                long txBytesStart = net.getBytesSent();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff01", e);
                }
                long end = System.currentTimeMillis();
                net.updateAttributes();
                long rxBytesEnd = net.getBytesRecv();
                long txBytesEnd = net.getBytesSent();
                netInterfaceDomain.setName(net.getName());
                netInterfaceDomain.setType("Ethernet");
                netInterfaceDomain.setAddress(iPv4addr[0]);
                double rxBps = (double)(rxBytesEnd - rxBytesStart) / ((double)(end - start) / 1000.0);
                double txBps = (double)(txBytesEnd - txBytesStart) / ((double)(end - start) / 1000.0);
                netInterfaceDomain.setDownloadBps(rxBps);
                netInterfaceDomain.setUploadBps(txBps);
                netInterfaceConfigDomains.add(netInterfaceDomain);
            }
            netDomain.setNetNum(netInterfaceConfigDomains.size());
            netDomain.setNetList(netInterfaceConfigDomains);
            return netDomain;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    private static boolean ignore(String[] iPv4addr, String macAddr, String netName) {
        return ArrayUtil.isEmpty(iPv4addr) || ArrayUtil.contains(iPv4addr, "127.0.0.1") || "00:00:00:00:00:00".equals(macAddr) || ArrayUtil.contains(iPv4addr, "0.0.0.0") || StrUtil.containsIgnoreCase(netName, "docker") || StrUtil.containsIgnoreCase(netName, "lo");
    }

    public static DiskDomain getDiskInfo() {
        try {
            DiskDomain diskDomain = new DiskDomain();
            ArrayList<DiskDomain.DiskInfoDomain> diskInfoDomains = new ArrayList<DiskDomain.DiskInfoDomain>();
            FileSystem fileSystem = SYSTEM_INFO.getOperatingSystem().getFileSystem();
            List<OSFileStore> fsArray = fileSystem.getFileStores(true);
            for (OSFileStore fs : fsArray) {
                DiskDomain.DiskInfoDomain diskInfoDomain = new DiskDomain.DiskInfoDomain();
                diskInfoDomain.setDevName(fs.getName());
                diskInfoDomain.setDirName(fs.getMount());
                diskInfoDomain.setTypeName(TYPE_NAME);
                diskInfoDomain.setSysTypeName(fs.getType());
                long total = fs.getTotalSpace();
                long usable = fs.getUsableSpace();
                long free = fs.getFreeSpace();
                long used = total - usable;
                diskInfoDomain.setTotal(total);
                diskInfoDomain.setFree(free);
                diskInfoDomain.setUsed(used);
                diskInfoDomain.setAvail(usable);
                diskInfoDomain.setUsePercent(total == 0L ? 0.0 : NumberUtil.round((double)used / (double)total, 4).doubleValue());
                diskInfoDomains.add(diskInfoDomain);
            }
            diskDomain.setDiskInfoList(diskInfoDomains);
            diskDomain.setDiskNum(diskInfoDomains.size());
            return diskDomain;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }
}

