/*
 * Decompiled with CFR 0.152.
 */
package com.cym.utils;

import com.cym.utils.MessageUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TimeExeUtils {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    MessageUtils m;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execCMD(String cmd, String[] envs, long timeout) {
        this.logger.info(cmd);
        Process process = null;
        StringBuilder sbStd = new StringBuilder();
        long start = System.currentTimeMillis();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", cmd);
            Map<String, String> environmentMap = processBuilder.environment();
            for (String env : envs) {
                String[] arrays = env.split("=");
                String key = arrays.length > 0 ? arrays[0] : "";
                String value = arrays.length > 1 ? arrays[1] : "";
                environmentMap.put(key, value);
            }
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            BufferedReader brStd = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while (true) {
                if (brStd.ready()) {
                    line = brStd.readLine();
                    sbStd.append(line).append("\n");
                    this.logger.info(line);
                    continue;
                }
                if (process != null) {
                    try {
                        process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() - start > timeout) {
                    line = this.m.get("certStr.timeout");
                    sbStd.append(line).append("\n");
                    this.logger.info(line);
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        this.logger.info(sbStd.toString());
        return sbStd.toString();
    }
}

