/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.noear.snack.ONode;
import org.noear.snack.OValue;
import org.noear.snack.OValueType;
import org.noear.snack.core.JsonPath$handler_$;
import org.noear.snack.core.exts.CharBuffer;
import org.noear.snack.core.exts.CharReader;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.exts.TmpCache;
import org.noear.snack.core.utils.StringUtil;

public class JsonPath {
    private static int _cacheSize = 1024;
    private static Map<String, JsonPath> _jpathCache = new HashMap<String, JsonPath>(128);
    private static final ThData<CharBuffer> tlBuilder = new ThData<CharBuffer>(() -> new CharBuffer());
    private static final ThData<TmpCache> tlCache = new ThData<TmpCache>(() -> new TmpCache());
    private List<Segment> segments = new ArrayList<Segment>();
    private static Map<String, Pattern> _regexLib = new HashMap<String, Pattern>();

    public static ONode eval(ONode source, String jpath, boolean useStandard, boolean cacheJpath) {
        return JsonPath.eval(source, jpath, useStandard, cacheJpath, CRUD.GET);
    }

    public static ONode eval(ONode source, String jpath, boolean useStandard, boolean cacheJpath, CRUD crud) {
        ((TmpCache)tlCache.get()).clear();
        return JsonPath.evalDo(source, jpath, cacheJpath, useStandard, crud);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ONode evalDo(ONode source, String jpath, boolean cacheJpath, boolean useStandard, CRUD crud) {
        JsonPath jsonPath = null;
        if (cacheJpath) {
            jsonPath = _jpathCache.get(jpath);
            if (jsonPath == null) {
                String string = jpath.intern();
                synchronized (string) {
                    jsonPath = _jpathCache.get(jpath);
                    if (jsonPath == null) {
                        jsonPath = JsonPath.compile(jpath);
                        if (_jpathCache.size() < _cacheSize) {
                            _jpathCache.put(jpath, jsonPath);
                        }
                    }
                }
            }
        } else {
            jsonPath = JsonPath.compile(jpath);
        }
        return JsonPath.exec(jsonPath, source, useStandard, crud);
    }

    public static void resolvePath(String parentPath, ONode parentNode) {
        block3: {
            block2: {
                parentNode.attrSet("$PATH", parentPath);
                if (!parentNode.isArray()) break block2;
                for (int i = 0; i < parentNode.count(); ++i) {
                    JsonPath.resolvePath(parentPath + "[" + i + "]", parentNode.get(i));
                }
                break block3;
            }
            if (!parentNode.isObject()) break block3;
            for (Map.Entry<String, ONode> kv : parentNode.obj().entrySet()) {
                JsonPath.resolvePath(parentPath + "['" + kv.getKey() + "']", kv.getValue());
            }
        }
    }

    public static void extractPath(List<String> paths, ONode oNode) {
        String path = oNode.attrGet("$PATH");
        if (StringUtil.isEmpty(path)) {
            if (oNode.isArray()) {
                for (int i = 0; i < oNode.count(); ++i) {
                    JsonPath.extractPath(paths, oNode.get(i));
                }
            } else if (oNode.isObject()) {
                for (Map.Entry<String, ONode> kv : oNode.obj().entrySet()) {
                    JsonPath.extractPath(paths, kv.getValue());
                }
            }
        } else {
            paths.add(path);
        }
    }

    public static void clear() {
        tlBuilder.remove();
        tlCache.remove();
    }

    private JsonPath() {
    }

    private static JsonPath compile(String jpath) {
        String jpath2 = jpath.replace("..", ".^");
        JsonPath jsonPath = new JsonPath();
        int token = 0;
        char c = '\u0000';
        char c_last = '\u0000';
        CharBuffer buffer = (CharBuffer)tlBuilder.get();
        buffer.setLength(0);
        CharReader reader = new CharReader(jpath2);
        while (true) {
            if ((c = reader.next()) == '\u0000') {
                if (buffer.length() <= 0) break;
                jsonPath.segments.add(new Segment(buffer.toString()));
                buffer.clear();
                break;
            }
            switch (c) {
                case '.': {
                    if (token > 0) {
                        buffer.append(c);
                        break;
                    }
                    if (buffer.length() <= 0) break;
                    jsonPath.segments.add(new Segment(buffer.toString()));
                    buffer.clear();
                    break;
                }
                case '(': {
                    if (token == 91) {
                        token = c;
                    }
                    buffer.append(c);
                    break;
                }
                case ')': {
                    if (token == 40) {
                        token = c;
                    }
                    buffer.append(c);
                    break;
                }
                case '[': {
                    if (token == 0) {
                        token = c;
                        if (buffer.length() <= 0 || c_last == '^') break;
                        jsonPath.segments.add(new Segment(buffer.toString()));
                        buffer.clear();
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case ']': {
                    if (token == 91 || token == 41) {
                        token = 0;
                        buffer.append(c);
                        if (buffer.length() <= 0) break;
                        jsonPath.segments.add(new Segment(buffer.toString()));
                        buffer.clear();
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            c_last = c;
        }
        return jsonPath;
    }

    private static ONode exec(JsonPath jsonPath, ONode source, boolean useStandard, CRUD crud) {
        ONode tmp = source;
        Segment last = null;
        boolean branch_do = false;
        boolean regroup = false;
        for (Segment s2 : jsonPath.segments) {
            if (tmp == null) break;
            if (branch_do && (useStandard || s2.cmdAry != null)) {
                ONode tmp2 = new ONode(null, source.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    ONode n2 = s2.handler.run(last, s2, regroup, source, n1, useStandard, crud);
                    if (n2 == null) continue;
                    if (s2.cmdAry != null) {
                        if (n2.isArray()) {
                            tmp2.addAll(n2.ary());
                            continue;
                        }
                        tmp2.addNode(n2);
                        continue;
                    }
                    tmp2.addNode(n2);
                }
                tmp = tmp2;
                if (!useStandard) {
                    branch_do = false;
                }
            } else {
                tmp = s2.handler.run(last, s2, regroup, source, tmp, useStandard, crud);
                branch_do = s2.cmdHasUnline;
            }
            if (s2.regroup) {
                regroup = true;
            } else if (s2.ranged) {
                regroup = false;
            }
            last = s2;
        }
        if (tmp == null) {
            return new ONode(null, source.options());
        }
        return tmp;
    }

    private static void scanByExpr(ONode source, List<ONode> target, Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
        if (source.isObject()) {
            ONode tmp2 = handler_ary_exp.instance.run(bef, s2, regroup, root, source, usd, crud);
            if (tmp2 != null) {
                target.add(tmp2);
            }
            for (Map.Entry<String, ONode> kv : source.obj().entrySet()) {
                JsonPath.scanByExpr(kv.getValue(), target, bef, s2, regroup, root, tmp, usd, crud);
            }
            return;
        }
        if (source.isArray()) {
            for (ONode n1 : source.ary()) {
                JsonPath.scanByExpr(n1, target, bef, s2, regroup, root, tmp, usd, crud);
            }
            return;
        }
    }

    private static void scanByName(String name, ONode source, List<ONode> target) {
        if (source.isObject()) {
            for (Map.Entry<String, ONode> kv : source.obj().entrySet()) {
                if (name.equals(kv.getKey())) {
                    target.add(kv.getValue());
                }
                JsonPath.scanByName(name, kv.getValue(), target);
            }
            return;
        }
        if (source.isArray()) {
            for (ONode n1 : source.ary()) {
                JsonPath.scanByName(name, n1, target);
            }
            return;
        }
    }

    private static void scanByAll(String name, ONode source, boolean isRoot, List<ONode> target) {
        if (!isRoot) {
            target.add(source);
        }
        if (source.isObject()) {
            for (Map.Entry<String, ONode> kv : source.obj().entrySet()) {
                JsonPath.scanByAll(name, kv.getValue(), false, target);
            }
            return;
        }
        if (source.isArray()) {
            for (ONode n1 : source.ary()) {
                JsonPath.scanByAll(name, n1, false, target);
            }
            return;
        }
    }

    private static boolean compare(ONode root, ONode parent, ONode leftO, String op, String right, boolean useStandard, CRUD crud) {
        if (leftO == null) {
            return false;
        }
        if (!leftO.isValue() || leftO.val().isNull()) {
            return false;
        }
        OValue left = leftO.val();
        ONode rightO = null;
        if (right.startsWith("$") && (rightO = (ONode)((TmpCache)tlCache.get()).get(right)) == null) {
            rightO = JsonPath.evalDo(root, right, true, useStandard, crud);
            ((TmpCache)tlCache.get()).put(right, rightO);
        }
        if (right.startsWith("@")) {
            rightO = JsonPath.evalDo(parent, right, true, useStandard, crud);
        }
        if (rightO != null) {
            right = rightO.isValue() ? (rightO.val().type() == OValueType.String ? "'" + rightO.getString() + "'" : rightO.getDouble() + "") : null;
        }
        switch (op) {
            case "==": {
                if (right == null) {
                    return false;
                }
                if (right.startsWith("'")) {
                    return left.getString().equals(right.substring(1, right.length() - 1));
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() == Double.parseDouble(right);
            }
            case "!=": {
                if (right == null) {
                    return false;
                }
                if (right.startsWith("'")) {
                    return !left.getString().equals(right.substring(1, right.length() - 1));
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() != Double.parseDouble(right);
            }
            case "<": {
                if (right == null) {
                    return false;
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() < Double.parseDouble(right);
            }
            case "<=": {
                if (right == null) {
                    return false;
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() <= Double.parseDouble(right);
            }
            case ">": {
                if (right == null) {
                    return false;
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() > Double.parseDouble(right);
            }
            case ">=": {
                if (right == null) {
                    return false;
                }
                if (left.type() == OValueType.String) {
                    return false;
                }
                return left.getDouble() >= Double.parseDouble(right);
            }
            case "=~": {
                if (right == null) {
                    return false;
                }
                int end = right.lastIndexOf(47);
                String exp = right.substring(1, end);
                return JsonPath.regex(right, exp).matcher(left.getString()).find();
            }
            case "in": {
                if (right == null) {
                    Object val = left.getRaw();
                    for (ONode n1 : rightO.ary()) {
                        if (!n1.val().getRaw().equals(val)) continue;
                        return true;
                    }
                    return false;
                }
                if (right.indexOf("'") > 0) {
                    return JsonPath.getStringAry(right).contains(left.getString());
                }
                return JsonPath.getDoubleAry(right).contains(left.getDouble());
            }
            case "nin": {
                if (right == null) {
                    Object val = left.getRaw();
                    for (ONode n1 : rightO.ary()) {
                        if (!n1.val().getRaw().equals(val)) continue;
                        return false;
                    }
                    return true;
                }
                if (right.indexOf("'") > 0) {
                    return !JsonPath.getStringAry(right).contains(left.getString());
                }
                return !JsonPath.getDoubleAry(right).contains(left.getDouble());
            }
        }
        return false;
    }

    private static List<String> getStringAry(String text) {
        String[] ss;
        ArrayList<String> ary = new ArrayList<String>();
        String test2 = text.substring(1, text.length() - 1);
        for (String s2 : ss = test2.split(",")) {
            ary.add(s2.substring(1, s2.length() - 1));
        }
        return ary;
    }

    private static List<Double> getDoubleAry(String text) {
        String[] ss;
        ArrayList<Double> ary = new ArrayList<Double>();
        String test2 = text.substring(1, text.length() - 1);
        for (String s2 : ss = test2.split(",")) {
            ary.add(Double.parseDouble(s2));
        }
        return ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pattern regex(String exprFull, String expr) {
        Pattern p = _regexLib.get(exprFull);
        if (p == null) {
            String string = exprFull.intern();
            synchronized (string) {
                if (p == null) {
                    p = exprFull.endsWith("i") ? Pattern.compile(expr, 2) : Pattern.compile(expr);
                    _regexLib.put(exprFull, p);
                }
            }
        }
        return p;
    }

    public static enum CRUD {
        GET,
        GET_OR_NEW,
        REMOVE;

    }

    private static class Segment {
        public final String cmd;
        public String cmdAry;
        public final boolean cmdHasQuote;
        public final boolean cmdHasUnline;
        public final boolean regroup;
        public List<Integer> indexS;
        public List<String> nameS;
        public String name;
        public int start = 0;
        public int end = 0;
        public boolean ranged = false;
        public String left;
        public String op;
        public String right;
        public Resolver handler;

        public Segment(String test) {
            this.cmd = test.trim();
            this.cmdHasQuote = this.cmd.indexOf("'") >= 0;
            this.cmdHasUnline = this.cmd.startsWith("^");
            boolean bl = this.regroup = this.cmd.contains("?") || this.cmd.startsWith("*");
            if (this.cmdHasUnline) {
                this.name = this.cmd.substring(1);
            }
            if (this.cmd.endsWith("]")) {
                this.cmdAry = this.cmdHasUnline ? this.cmd.substring(1, this.cmd.length() - 1).trim() : this.cmd.substring(0, this.cmd.length() - 1).trim();
                if (this.cmdAry.startsWith("?")) {
                    String s2 = this.cmdAry.substring(2, this.cmdAry.length() - 1);
                    String[] ss2 = s2.split(" ");
                    this.left = ss2[0];
                    if (ss2.length == 3) {
                        this.op = ss2[1];
                        this.right = ss2[2];
                    }
                } else if (this.cmdAry.indexOf(":") >= 0) {
                    String[] iAry = this.cmdAry.split(":", -1);
                    this.start = 0;
                    if (iAry[0].length() > 0) {
                        this.start = Integer.parseInt(iAry[0]);
                    }
                    this.end = 0;
                    if (iAry[1].length() > 0) {
                        this.end = Integer.parseInt(iAry[1]);
                    }
                    this.ranged = true;
                } else if (this.cmdAry.indexOf(",") > 0) {
                    if (this.cmdAry.indexOf("'") >= 0) {
                        String[] iAry;
                        this.nameS = new ArrayList<String>();
                        for (String i1 : iAry = this.cmdAry.split(",")) {
                            i1 = i1.trim();
                            this.nameS.add(i1.substring(1, i1.length() - 1));
                        }
                    } else {
                        String[] iAry;
                        this.indexS = new ArrayList<Integer>();
                        for (String i1 : iAry = this.cmdAry.split(",")) {
                            i1 = i1.trim();
                            this.indexS.add(Integer.parseInt(i1));
                        }
                    }
                } else if (this.cmdAry.indexOf("'") >= 0) {
                    this.name = this.cmdAry.substring(1, this.cmdAry.length() - 1);
                } else if (StringUtil.isInteger(this.cmdAry)) {
                    this.start = Integer.parseInt(this.cmdAry);
                    this.ranged = true;
                }
            }
            if ("$".equals(this.cmd) || "@".equals(this.cmd)) {
                this.handler = JsonPath$handler_$.instance;
                return;
            }
            if (this.cmd.startsWith("^")) {
                this.handler = handler_xx.instance;
                return;
            }
            if ("*".equals(this.cmd)) {
                this.handler = handler_x.instance;
                return;
            }
            if (this.cmd.endsWith("]")) {
                if ("*".equals(this.cmdAry)) {
                    this.handler = handler_ary_x.instance;
                    return;
                }
                this.handler = this.cmd.startsWith("?") ? handler_ary_exp.instance : (this.cmdAry.indexOf(",") > 0 ? handler_ary_multi.instance : (this.cmdAry.indexOf(":") >= 0 ? handler_ary_range.instance : (this.cmdAry.startsWith("$.") || this.cmdAry.startsWith("@.") ? handler_ary_ref.instance : handler_ary_prop.instance)));
            } else {
                this.handler = this.cmd.endsWith(")") ? handler_fun.instance : handler_prop.instance;
            }
        }

        public int length() {
            return this.cmd.length();
        }

        public String toString() {
            return this.cmd;
        }
    }

    @FunctionalInterface
    private static interface Resolver {
        public ONode run(Segment var1, Segment var2, Boolean var3, ONode var4, ONode var5, Boolean var6, CRUD var7);
    }

    private static class handler_ary_prop
    implements Resolver {
        static final handler_ary_prop instance = new handler_ary_prop();

        private handler_ary_prop() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            if (s2.cmdHasQuote) {
                if (tmp.isObject()) {
                    return tmp.getOrNull(s2.name);
                }
                if (tmp.isArray()) {
                    ONode tmp2 = new ONode(null, tmp.options()).asArray();
                    for (ONode n1 : tmp.ary()) {
                        ONode n2;
                        if (!n1.isObject() || (n2 = n1.nodeData().object.get(s2.name)) == null) continue;
                        tmp2.add(n2);
                    }
                    return tmp2;
                }
                return null;
            }
            if (regroup.booleanValue()) {
                ONode tmp2 = new ONode(null, tmp.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    ONode n2 = null;
                    n2 = s2.start < 0 ? (crud == CRUD.GET_OR_NEW ? n1.getOrNew(n1.count() + s2.start) : n1.getOrNull(n1.count() + s2.start)) : (crud == CRUD.GET_OR_NEW ? n1.getOrNew(s2.start) : n1.getOrNull(s2.start));
                    if (n2 == null) continue;
                    tmp2.add(n2);
                }
                return tmp2;
            }
            if (s2.start < 0) {
                if (crud == CRUD.GET_OR_NEW) {
                    return tmp.getOrNew(tmp.count() + s2.start);
                }
                return tmp.getOrNull(tmp.count() + s2.start);
            }
            if (crud == CRUD.GET_OR_NEW) {
                return tmp.getOrNew(s2.start);
            }
            return tmp.getOrNull(s2.start);
        }
    }

    private static class handler_ary_range
    implements Resolver {
        static final handler_ary_range instance = new handler_ary_range();

        private handler_ary_range() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            if (tmp.isArray()) {
                int count = tmp.count();
                int start = s2.start;
                int end = s2.end;
                if (start < 0) {
                    start = count + start;
                }
                if (end == 0) {
                    end = count;
                }
                if (end < 0) {
                    end = count + end;
                }
                if (start < 0) {
                    start = 0;
                }
                if (end > count) {
                    end = count;
                }
                return new ONode(null, tmp.options()).addAll(tmp.ary().subList(start, end));
            }
            return null;
        }
    }

    private static class handler_ary_multi
    implements Resolver {
        static final handler_ary_multi instance = new handler_ary_multi();

        private handler_ary_multi() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            ONode tmp2;
            block9: {
                block8: {
                    tmp2 = null;
                    if (s2.cmdAry.indexOf("'") < 0) break block8;
                    if (tmp.isObject()) {
                        for (String k : s2.nameS) {
                            ONode n1 = tmp.obj().get(k);
                            if (n1 == null) continue;
                            if (tmp2 == null) {
                                tmp2 = new ONode(null, tmp.options()).asArray();
                            }
                            tmp2.addNode(n1);
                        }
                    }
                    if (!tmp.isArray()) break block9;
                    tmp2 = new ONode(null, tmp.options()).asArray();
                    for (ONode tmp1 : tmp.ary()) {
                        if (!tmp1.isObject()) continue;
                        for (String k : s2.nameS) {
                            ONode n1 = tmp1.obj().get(k);
                            if (n1 == null) continue;
                            tmp2.addNode(n1);
                        }
                    }
                    break block9;
                }
                if (tmp.isArray()) {
                    List<ONode> list2 = tmp.nodeData().array;
                    int len2 = list2.size();
                    for (int idx : s2.indexS) {
                        if (idx < 0 || idx >= len2) continue;
                        if (tmp2 == null) {
                            tmp2 = new ONode(null, tmp.options()).asArray();
                        }
                        tmp2.addNode(list2.get(idx));
                    }
                }
            }
            return tmp2;
        }
    }

    private static class handler_ary_ref
    implements Resolver {
        static final handler_ary_ref instance = new handler_ary_ref();

        private handler_ary_ref() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            ONode tmp2 = null;
            if (tmp.isObject()) {
                tmp2 = s2.cmdAry.startsWith("$") ? JsonPath.evalDo(root, s2.cmdAry, true, usd, crud) : JsonPath.evalDo(tmp, s2.cmdAry, true, usd, crud);
                tmp2 = tmp2.isValue() ? tmp.get(tmp2.getString()) : null;
            }
            return tmp2;
        }
    }

    private static class handler_ary_exp
    implements Resolver {
        static final handler_ary_exp instance = new handler_ary_exp();

        private handler_ary_exp() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            ONode tmp2 = tmp;
            if (s2.op == null) {
                if (tmp.isObject()) {
                    if (!JsonPath.evalDo(tmp, s2.left, true, usd, crud).isNull()) return tmp2;
                    return null;
                }
                if (!tmp.isArray()) return null;
                tmp2 = new ONode(null, tmp.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    if (n1.isObject() && !JsonPath.evalDo(n1, s2.left, true, usd, crud).isNull()) {
                        tmp2.nodeData().array.add(n1);
                    }
                    if (!regroup.booleanValue() || !n1.isArray()) continue;
                    for (ONode n2 : n1.ary()) {
                        if (!n2.isObject() || JsonPath.evalDo(n2, s2.left, true, usd, crud).isNull()) continue;
                        tmp2.nodeData().array.add(n2);
                    }
                }
                return tmp2;
            }
            if (tmp.isObject()) {
                if ("@".equals(s2.left)) {
                    return null;
                }
                ONode leftO = JsonPath.evalDo(tmp, s2.left, true, usd, crud);
                if (JsonPath.compare(root, tmp, leftO, s2.op, s2.right, usd, crud)) return tmp2;
                return null;
            }
            if (tmp.isArray()) {
                tmp2 = new ONode(null, tmp.options()).asArray();
                if ("@".equals(s2.left)) {
                    for (ONode n1 : tmp.ary()) {
                        if (n1.isArray()) {
                            for (ONode n2 : n1.ary()) {
                                if (!JsonPath.compare(root, n2, n2, s2.op, s2.right, usd, crud)) continue;
                                tmp2.addNode(n2);
                            }
                            continue;
                        }
                        if (!JsonPath.compare(root, n1, n1, s2.op, s2.right, usd, crud)) continue;
                        tmp2.addNode(n1);
                    }
                    return tmp2;
                }
                for (ONode n1 : tmp.ary()) {
                    if (n1.isArray()) {
                        for (ONode n2 : n1.ary()) {
                            ONode leftO;
                            if (!JsonPath.compare(root, n2, leftO = JsonPath.evalDo(n2, s2.left, true, usd, crud), s2.op, s2.right, usd, crud)) continue;
                            tmp2.addNode(n2);
                        }
                        continue;
                    }
                    ONode leftO = JsonPath.evalDo(n1, s2.left, true, usd, crud);
                    if (!JsonPath.compare(root, n1, leftO, s2.op, s2.right, usd, crud)) continue;
                    tmp2.addNode(n1);
                }
                return tmp2;
            }
            if (!tmp.isValue()) return tmp2;
            if (!"@".equals(s2.left)) return null;
            if (JsonPath.compare(root, tmp, tmp, s2.op, s2.right, usd, crud)) return tmp2;
            return null;
        }
    }

    private static class handler_ary_x
    implements Resolver {
        static final handler_ary_x instance = new handler_ary_x();

        private handler_ary_x() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            ONode tmp2 = null;
            if (tmp.isArray()) {
                if (regroup.booleanValue()) {
                    tmp2 = new ONode(null, tmp.options()).asArray();
                    for (ONode n1 : tmp.ary()) {
                        if (n1.isObject()) {
                            tmp2.addAll(n1.obj().values());
                            continue;
                        }
                        tmp2.addAll(n1.ary());
                    }
                } else {
                    tmp2 = tmp;
                }
            }
            if (tmp.isObject()) {
                tmp2 = new ONode(null, tmp.options()).asArray();
                tmp2.addAll(tmp.obj().values());
            }
            return tmp2;
        }
    }

    private static class handler_fun
    implements Resolver {
        static final handler_fun instance = new handler_fun();

        private handler_fun() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            switch (s2.cmd) {
                case "size()": {
                    return new ONode(null, tmp.options()).val(tmp.count());
                }
                case "length()": {
                    if (tmp.isValue()) {
                        return new ONode(null, tmp.options()).val(tmp.getString().length());
                    }
                    return new ONode(null, tmp.options()).val(tmp.count());
                }
                case "keys()": {
                    if (tmp.isObject()) {
                        return new ONode(null, tmp.options()).addAll(tmp.obj().keySet());
                    }
                    return null;
                }
                case "min()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        ONode min_n = null;
                        for (ONode n1 : tmp.ary()) {
                            if (n1.isValue()) {
                                if (min_n == null) {
                                    min_n = n1;
                                } else if (n1.getDouble() < min_n.getDouble()) {
                                    min_n = n1;
                                }
                            }
                            if (!regroup.booleanValue() || !n1.isArray()) continue;
                            for (ONode n2 : n1.ary()) {
                                if (!n2.isValue()) continue;
                                if (min_n == null) {
                                    min_n = n2;
                                    continue;
                                }
                                if (!(n2.getDouble() < min_n.getDouble())) continue;
                                min_n = n2;
                            }
                        }
                        return min_n;
                    }
                    return null;
                }
                case "max()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        ONode max_n = null;
                        for (ONode n1 : tmp.ary()) {
                            if (n1.isValue()) {
                                if (max_n == null) {
                                    max_n = n1;
                                } else if (n1.getDouble() > max_n.getDouble()) {
                                    max_n = n1;
                                }
                            }
                            if (!regroup.booleanValue() || !n1.isArray()) continue;
                            for (ONode n2 : n1.ary()) {
                                if (!n2.isValue()) continue;
                                if (max_n == null) {
                                    max_n = n2;
                                    continue;
                                }
                                if (!(n2.getDouble() > max_n.getDouble())) continue;
                                max_n = n2;
                            }
                        }
                        return max_n;
                    }
                    return null;
                }
                case "avg()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        double sum = 0.0;
                        int num = 0;
                        for (ONode n1 : tmp.ary()) {
                            if (n1.isValue()) {
                                sum += n1.getDouble();
                                ++num;
                            }
                            if (!regroup.booleanValue() || !n1.isArray()) continue;
                            for (ONode n2 : n1.ary()) {
                                if (!n2.isValue()) continue;
                                sum += n2.getDouble();
                                ++num;
                            }
                        }
                        if (num > 0) {
                            return new ONode(null, tmp.options()).val(sum / (double)num);
                        }
                    }
                    return null;
                }
                case "sum()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        double sum = 0.0;
                        for (ONode n1 : tmp.ary()) {
                            if (n1.isValue()) {
                                sum += n1.getDouble();
                            }
                            if (!regroup.booleanValue() || !n1.isArray()) continue;
                            for (ONode n2 : n1.ary()) {
                                if (!n2.isValue()) continue;
                                sum += n2.getDouble();
                            }
                        }
                        return new ONode(null, tmp.options()).val(sum);
                    }
                    return null;
                }
                case "first()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        ONode n1 = tmp.get(0);
                        if (regroup.booleanValue() && n1.isArray()) {
                            return n1.get(0);
                        }
                        return n1;
                    }
                    return null;
                }
                case "last()": {
                    if (tmp.isArray()) {
                        if (tmp.count() == 0) {
                            return null;
                        }
                        ONode n1 = tmp.get(tmp.count() - 1);
                        if (regroup.booleanValue() && n1.isArray()) {
                            return n1.get(n1.count() - 1);
                        }
                        return n1;
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static class handler_prop
    implements Resolver {
        static final handler_prop instance = new handler_prop();

        private handler_prop() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            if (tmp.isObject()) {
                if (crud == CRUD.GET_OR_NEW) {
                    return tmp.getOrNew(s2.cmd);
                }
                return tmp.getOrNull(s2.cmd);
            }
            if (tmp.isArray()) {
                ONode tmp2 = new ONode(null, tmp.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    if (n1.isObject()) {
                        if (crud == CRUD.GET_OR_NEW) {
                            tmp2.add(n1.getOrNew(s2.cmd));
                        } else {
                            ONode n2 = n1.nodeData().object.get(s2.cmd);
                            if (n2 != null) {
                                tmp2.add(n2);
                            }
                        }
                    }
                    if (!regroup.booleanValue() || !n1.isArray()) continue;
                    for (ONode n2 : n1.ary()) {
                        if (!n2.isObject()) continue;
                        if (crud == CRUD.GET_OR_NEW) {
                            tmp2.add(n2.getOrNew(s2.cmd));
                            continue;
                        }
                        ONode n3 = n2.nodeData().object.get(s2.cmd);
                        if (n3 == null) continue;
                        tmp2.add(n3);
                    }
                }
                return tmp2;
            }
            if (crud == CRUD.GET_OR_NEW && tmp.isNull()) {
                return tmp.getOrNew(s2.cmd);
            }
            return null;
        }
    }

    private static class handler_x
    implements Resolver {
        static final handler_x instance = new handler_x();

        private handler_x() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD crud) {
            ONode tmp2 = null;
            if (tmp.count() > 0) {
                tmp2 = new ONode(null, tmp.options()).asArray();
                if (tmp.isObject()) {
                    tmp2.addAll(tmp.obj().values());
                } else if (tmp.isArray()) {
                    if (regroup.booleanValue()) {
                        for (ONode n1 : tmp.ary()) {
                            if (n1.isObject()) {
                                tmp2.addAll(n1.obj().values());
                                continue;
                            }
                            tmp2.addAll(n1.ary());
                        }
                    } else {
                        tmp2.addAll(tmp.ary());
                    }
                }
            }
            return tmp2;
        }
    }

    private static class handler_xx
    implements Resolver {
        static final handler_xx instance = new handler_xx();

        private handler_xx() {
        }

        @Override
        public ONode run(Segment bef, Segment s2, Boolean regroup, ONode root, ONode tmp, Boolean usd, CRUD orNew) {
            if (s2.name.length() > 0) {
                ONode tmp2 = new ONode(null, root.options()).asArray();
                if ("*".equals(s2.name)) {
                    JsonPath.scanByAll(s2.name, tmp, true, tmp2.ary());
                } else if (s2.name.startsWith("?")) {
                    JsonPath.scanByExpr(tmp, tmp2.ary(), bef, s2, regroup, root, tmp, usd, orNew);
                } else {
                    JsonPath.scanByName(s2.name, tmp, tmp2.ary());
                }
                if (tmp2.count() > 0) {
                    return tmp2;
                }
            }
            return null;
        }
    }
}

