/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.exts.Unitype;
import org.noear.snack.core.utils.GenericUtil;

public class ClassWrap {
    private static Map<Unitype, ClassWrap> cached = new ConcurrentHashMap<Unitype, ClassWrap>();
    private final Unitype _unitype;
    private final Map<String, FieldWrap> _fieldAllWraps;
    private final Map<String, Method> _propertyAll;
    private boolean _recordable;
    private Constructor _recordConstructor;
    private Parameter[] _recordParams;
    private boolean _isMemberClass;

    public static ClassWrap get(Unitype typeDecl) {
        ClassWrap l;
        ClassWrap cw = cached.get(typeDecl);
        if (cw == null && (l = cached.putIfAbsent(typeDecl, cw = new ClassWrap(typeDecl))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Unitype unitype) {
        Constructor<?>[] constructors;
        this._unitype = unitype;
        this._recordable = true;
        this._isMemberClass = unitype.getType().isMemberClass();
        this._fieldAllWraps = new LinkedHashMap<String, FieldWrap>();
        this._propertyAll = new LinkedHashMap<String, Method>();
        this.scanAllFields(unitype, this._fieldAllWraps::containsKey, this._fieldAllWraps::put);
        for (Method m4 : unitype.getType().getMethods()) {
            if (!m4.getName().startsWith("set") || m4.getName().length() <= 3 || m4.getParameterCount() != 1) continue;
            String name = m4.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            this._propertyAll.put(name, m4);
        }
        if (this._fieldAllWraps.size() == 0) {
            this._recordable = false;
        }
        if ((constructors = unitype.getType().getConstructors()).length > 0) {
            if (this._recordable) {
                this._recordConstructor = constructors[constructors.length - 1];
                this._recordParams = this._recordConstructor.getParameters();
                if (this._recordParams.length == 0) {
                    this._recordable = false;
                }
            } else if (constructors.length == 1 && constructors[0].getParameterCount() > 0) {
                this._recordConstructor = constructors[0];
                this._recordParams = this._recordConstructor.getParameters();
            }
        } else {
            this._recordable = false;
        }
    }

    public Collection<FieldWrap> fieldAllWraps() {
        return this._fieldAllWraps.values();
    }

    public FieldWrap getFieldWrap(String fieldName) {
        return this._fieldAllWraps.get(fieldName);
    }

    public Method getProperty(String name) {
        return this._propertyAll.get(name);
    }

    public boolean recordable() {
        return this._recordable;
    }

    public Constructor recordConstructor() {
        return this._recordConstructor;
    }

    public Parameter[] recordParams() {
        return this._recordParams;
    }

    private void scanAllFields(Unitype unitype, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (unitype == null) {
            return;
        }
        if (unitype.getType().isInterface()) {
            return;
        }
        for (Field f : unitype.getType().getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || this._isMemberClass && f.getName().equals("this$0") || checker.test(f.getName())) continue;
            this._recordable &= Modifier.isFinal(mod);
            consumer.accept(f.getName(), new FieldWrap(unitype, f, Modifier.isFinal(mod)));
        }
        Class<?> sup = unitype.getType().getSuperclass();
        if (sup != null && sup != Object.class) {
            Type supInfo = GenericUtil.reviewType(unitype.getType().getGenericSuperclass(), unitype.getGenericType());
            this.scanAllFields(new Unitype(sup, supInfo), checker, consumer);
        }
    }
}

