/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.core.util.IoUtil;

public class HttpPartFile {
    private static Path tempdir;
    private File tempfile;
    private final InputStream content;
    private final long size;

    public HttpPartFile(String filename, InputStream ins) throws IOException {
        if (ServerProps.request_useTempfile && Utils.isNotEmpty(filename)) {
            if (tempdir == null) {
                Utils.locker().lock();
                try {
                    if (tempdir == null) {
                        tempdir = Files.createTempDirectory("solon.upload.", new FileAttribute[0]);
                    }
                }
                finally {
                    Utils.locker().unlock();
                }
            }
            this.tempfile = Files.createTempFile(tempdir, "solon.", ".tmp", new FileAttribute[0]).toFile();
            try (BufferedOutputStream outs = new BufferedOutputStream(new FileOutputStream(this.tempfile));){
                IoUtil.transferTo(ins, outs);
            }
            this.size = this.tempfile.length();
            this.content = new FileInputStream(this.tempfile);
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IoUtil.transferTo(ins, output);
            this.size = output.size();
            this.content = new ByteArrayInputStream(output.toByteArray());
        }
    }

    public void delete() throws IOException {
        if (this.tempfile != null) {
            try {
                this.content.close();
            }
            finally {
                this.tempfile.delete();
            }
        }
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public long getSize() throws IOException {
        return this.size;
    }
}

