/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.jsp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagFileInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.jasper.deploy.TagVariableInfo;
import org.jboss.annotation.javaee.Icon;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.util.SupplierEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspTldLocator {
    static final Logger log = LoggerFactory.getLogger(JspTldLocator.class);

    public static Map<String, TagLibraryInfo> createTldInfos(String ... dltDirs) throws IOException {
        List<URL> urls = JspTldLocator.getURLs();
        HashMap<String, TagLibraryInfo> tagLibInfos = new HashMap<String, TagLibraryInfo>();
        for (URL url : urls) {
            if (!url.toString().endsWith(".jar")) continue;
            try {
                String file_uri = URLDecoder.decode(url.getFile(), Solon.encoding());
                JarFile jarFile = new JarFile(file_uri);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".tld")) continue;
                    JspTldLocator.loadTagLibraryInfo(tagLibInfos, () -> {
                        JarEntry fileEntry = jarFile.getJarEntry(entry.getName());
                        return jarFile.getInputStream(fileEntry);
                    });
                }
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
        try {
            for (String dltDir : dltDirs) {
                ScanUtil.scan(AppClassLoader.global(), dltDir, n -> n.endsWith(".tld")).forEach(uri -> JspTldLocator.loadTagLibraryInfo(tagLibInfos, () -> ResourceUtil.getResource(uri).openStream()));
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        return tagLibInfos;
    }

    static List<URL> getURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            String[] list;
            String separator = System.getProperty("path.separator");
            if (Utils.isEmpty(separator)) {
                separator = ":";
            }
            for (String uri : list = classPath.split(separator)) {
                if (!uri.endsWith(".jar") && uri.indexOf(".jar ") <= 0) continue;
                try {
                    if (uri.startsWith("/")) {
                        uri = "file:" + uri;
                    }
                    URL url = URI.create(uri).toURL();
                    urls.add(url);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadTagLibraryInfo(HashMap<String, TagLibraryInfo> tagLibInfos, SupplierEx<InputStream> supplier) {
        InputStream is = null;
        try {
            is = supplier.get();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetadata = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            TagLibraryInfo taglibInfo = JspTldLocator.getTagLibraryInfo(tldMetadata);
            if (!tagLibInfos.containsKey(taglibInfo.getUri())) {
                tagLibInfos.put(taglibInfo.getUri(), taglibInfo);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException inputFactory) {}
        }
    }

    static TagLibraryInfo getTagLibraryInfo(TldMetaData tldMetaData) {
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo ari = new TagAttributeInfo();
                        ari.setName(attributeMetaData.getName());
                        ari.setType(attributeMetaData.getType());
                        ari.setReqTime(attributeMetaData.getRtexprvalue());
                        ari.setRequired(attributeMetaData.getRequired());
                        ari.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            ari.setDeferredValue("true");
                            ari.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            ari.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            ari.setDeferredMethod("true");
                            ari.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            ari.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(ari);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tfi = new TagFileInfo();
                tfi.setName(tagFileMetaData.getName());
                tfi.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tfi);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo fi = new FunctionInfo();
                fi.setName(functionMetaData.getName());
                fi.setFunctionClass(functionMetaData.getFunctionClass());
                fi.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(fi);
            }
        }
        return tagLibraryInfo;
    }
}

