/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.boot.undertow.websocket.UtWsChannelListener;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;

public class UtWsConnectionCallback
implements WebSocketConnectionCallback {
    private final UtWsChannelListener listener = new UtWsChannelListener();
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onHandshake(WebSocketHttpExchange exchange) {
        String protocols;
        String uri = DecodeUtils.rinseUri(exchange.getRequestURI());
        String path = URI.create(uri).getPath();
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null && Utils.isNotEmpty(protocols = subProtocolCapable.getSubProtocols((Collection<String>)exchange.getRequestHeaders().get("Sec-WebSocket-Protocol")))) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", protocols);
        }
    }

    @Override
    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        this.listener.onOpen(exchange, channel);
        channel.getReceiveSetter().set(this.listener);
        channel.resumeReceives();
    }
}

