/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.boot.undertow.websocket.CallbackFuture;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;

public class WebSocketImpl
extends WebSocketBase {
    private WebSocketChannel real;

    public WebSocketImpl(WebSocketChannel real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri(real.getUrl());
        this.init(URI.create(uri));
    }

    @Override
    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    @Override
    public boolean isSecure() {
        return this.real.isSecure();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.real.getSourceAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.real.getDestinationAddress();
    }

    @Override
    public long getIdleTimeout() {
        return this.real.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(idleTimeout);
    }

    @Override
    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendText(text, this.real, (WebSocketCallback<Void>)future);
        return future;
    }

    @Override
    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendBinary(binary, this.real, (WebSocketCallback<Void>)future);
        return future;
    }

    @Override
    public void close() {
        super.close();
        RunUtil.runAndTry(this.real::close);
    }
}

