/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.mvc;

import java.lang.reflect.AnnotatedElement;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Cookie;
import org.noear.solon.annotation.Header;
import org.noear.solon.annotation.Param;
import org.noear.solon.annotation.Path;
import org.noear.solon.core.handle.ActionParam;

public class ActionParamResolver {
    public static void resolve(ActionParam vo, AnnotatedElement element) {
        if (ActionParamResolver.resolveBody(vo, element)) {
            return;
        }
        if (ActionParamResolver.resolveParam(vo, element)) {
            return;
        }
        if (ActionParamResolver.resolvePath(vo, element)) {
            return;
        }
        if (ActionParamResolver.resolveHeader(vo, element)) {
            return;
        }
        ActionParamResolver.resolveCookie(vo, element);
    }

    private static boolean resolveBody(ActionParam vo, AnnotatedElement element) {
        Body bodyAnno = element.getAnnotation(Body.class);
        if (bodyAnno == null) {
            return false;
        }
        vo.isRequiredBody = true;
        return true;
    }

    private static boolean resolveParam(ActionParam vo, AnnotatedElement element) {
        Param paramAnno = element.getAnnotation(Param.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            vo.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(paramAnno.defaultValue())) {
            vo.defaultValue = paramAnno.defaultValue();
        }
        vo.isRequiredInput = paramAnno.required();
        return true;
    }

    private static boolean resolvePath(ActionParam vo, AnnotatedElement element) {
        Path pathAnno = element.getAnnotation(Path.class);
        if (pathAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(pathAnno.value(), pathAnno.name());
        if (Utils.isNotEmpty(name2)) {
            vo.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(pathAnno.defaultValue())) {
            vo.defaultValue = pathAnno.defaultValue();
        }
        vo.isRequiredInput = pathAnno.required();
        vo.isRequiredPath = true;
        return true;
    }

    private static boolean resolveHeader(ActionParam vo, AnnotatedElement element) {
        Header headerAnno = element.getAnnotation(Header.class);
        if (headerAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(headerAnno.value(), headerAnno.name());
        if (Utils.isNotEmpty(name2)) {
            vo.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerAnno.defaultValue())) {
            vo.defaultValue = headerAnno.defaultValue();
        }
        vo.isRequiredInput = headerAnno.required();
        vo.isRequiredHeader = true;
        return true;
    }

    private static boolean resolveCookie(ActionParam vo, AnnotatedElement element) {
        Cookie cookieAnno = element.getAnnotation(Cookie.class);
        if (cookieAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(cookieAnno.value(), cookieAnno.name());
        if (Utils.isNotEmpty(name2)) {
            vo.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(cookieAnno.defaultValue())) {
            vo.defaultValue = cookieAnno.defaultValue();
        }
        vo.isRequiredInput = cookieAnno.required();
        vo.isRequiredCookie = true;
        return true;
    }
}

