/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.core.ChainManager;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Router;

public class RouterHandler
implements Handler {
    private Router router;
    private ChainManager chainManager;

    public RouterHandler(Router router, ChainManager chainManager) {
        this.router = router;
        this.chainManager = chainManager;
    }

    protected boolean handleMain(Handler h2, Context ctx) throws Throwable {
        if (h2 != null) {
            this.chainManager.refreshSessionState(ctx);
            h2.handle(ctx);
            return ctx.status() != 404;
        }
        int code = ctx.attrOrDefault("ATTR_MAIN_STATUS", 404);
        if (code == 405) {
            throw new StatusException("Method Not Allowed: " + ctx.method() + " " + ctx.pathNew(), code);
        }
        throw new StatusException("Not Found: " + ctx.method() + " " + ctx.pathNew(), code);
    }

    private void handle1(Context x) throws Throwable {
        try {
            if (!x.getHandled()) {
                Handler mainHandler = (Handler)x.attr("ATTR_MAIN_HANDLER");
                boolean handled = this.handleMain(mainHandler, x);
                x.setHandled(handled);
            }
        }
        catch (Throwable e) {
            if (x.errors == null) {
                x.errors = e;
            }
            throw e;
        }
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        Result<Handler> result = this.router.matchMainAndStatus(x);
        if (result.getData() != null) {
            x.attrSet("ATTR_MAIN_HANDLER", result.getData());
            x.attrSet("ATTR_MAIN_STATUS", 200);
        } else {
            x.attrSet("ATTR_MAIN_HANDLER", null);
            x.attrSet("ATTR_MAIN_STATUS", result.getCode());
        }
        this.chainManager.doIntercept(x, result.getData(), this::handle1);
    }
}

