/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.util.RankEntity;

public class RoutingTableDefault<T>
implements RoutingTable<T> {
    private LinkedList<RankEntity<Routing<T>>> table = new LinkedList();

    @Override
    public void add(Routing<T> routing) {
        int level = 0;
        if (routing.path().indexOf(123) >= 0) {
            level = 1;
        }
        if (routing.path().indexOf(42) >= 0) {
            level = 2;
        }
        RankEntity<Routing<T>> entity = new RankEntity<Routing<T>>(routing, level, routing.index(), false);
        if (level != 0 || routing.index() != 0) {
            this.table.addLast(entity);
            Collections.sort(this.table);
        } else {
            this.table.addFirst(entity);
        }
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.removeIf(l -> ((Routing)l.target).path().startsWith(pathPrefix));
    }

    @Override
    public void remove(Class<?> controllerClz) {
        this.table.removeIf(l -> {
            Action a;
            return ((Routing)l.target).target() instanceof Action && (a = (Action)((Routing)l.target).target()).controller().clz().equals(controllerClz);
        });
    }

    @Override
    public int count() {
        return this.table.size();
    }

    @Override
    public Collection<Routing<T>> getAll() {
        return this.table.stream().map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(String pathPrefix) {
        return this.table.stream().filter(l -> ((Routing)l.target).path().startsWith(pathPrefix)).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(Class<?> controllerClz) {
        return this.table.stream().filter(l -> {
            Action a;
            return ((Routing)l.target).target() instanceof Action && (a = (Action)((Routing)l.target).target()).controller().clz().equals(controllerClz);
        }).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public T matchOne(String path, MethodType method) {
        for (RankEntity rankEntity : this.table) {
            if (!((Routing)rankEntity.target).matches(method, path)) continue;
            return ((Routing)rankEntity.target).target();
        }
        return null;
    }

    @Override
    public Result<T> matchOneAndStatus(String path, MethodType method) {
        int degrees2 = 0;
        for (RankEntity rankEntity : this.table) {
            int tmp = ((Routing)rankEntity.target).degrees(method, path);
            if (tmp == 2) {
                return Result.succeed(((Routing)rankEntity.target).target());
            }
            if (tmp <= degrees2) continue;
            degrees2 = tmp;
        }
        if (degrees2 == 1) {
            return Result.failure(405);
        }
        return Result.failure(404);
    }

    @Override
    public List<T> matchMore(String path, MethodType method) {
        return this.table.stream().filter(l -> ((Routing)l.target).matches(method, path)).map(l -> ((Routing)l.target).target()).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.table.clear();
    }
}

