/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Around;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.MethodHolder;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.TypeWrap;
import org.noear.solon.lang.Nullable;

public class MethodWrap
implements Interceptor,
MethodHolder {
    private final AppContext context;
    private final Class<?> ownerClz;
    private final Class<?> declaringClz;
    private final Method method;
    private final Parameter[] parameters;
    private final Annotation[] annotations;
    private final List<InterceptorEntity> interceptors;
    private final Set<Interceptor> interceptorsIdx;
    private TypeWrap __returnTypeWrap;
    private ParamWrap[] __paramWraps;

    public MethodWrap(AppContext ctx, Class<?> clz, Method m4) {
        this.context = ctx;
        this.ownerClz = clz;
        this.declaringClz = m4.getDeclaringClass();
        this.method = m4;
        this.parameters = m4.getParameters();
        this.annotations = m4.getAnnotations();
        this.interceptors = new ArrayList<InterceptorEntity>();
        this.interceptorsIdx = new HashSet<Interceptor>();
        if (this.context != null) {
            InterceptorEntity ie;
            for (Annotation anno : this.annotations) {
                if (anno instanceof Around) {
                    this.doInterceptorAdd((Around)anno);
                    continue;
                }
                ie = this.context.beanInterceptorGet(anno.annotationType());
                if (ie != null) {
                    this.doInterceptorAdd(ie);
                    continue;
                }
                this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
            }
            for (Annotation anno : this.ownerClz.getAnnotations()) {
                if (anno instanceof Around) {
                    this.doInterceptorAdd((Around)anno);
                    continue;
                }
                ie = this.context.beanInterceptorGet(anno.annotationType());
                if (ie != null) {
                    this.doInterceptorAdd(ie);
                    continue;
                }
                this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
            }
        }
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        this.interceptors.add(new InterceptorEntity(0, this));
    }

    private TypeWrap returnTypeWrap() {
        if (this.__returnTypeWrap == null) {
            this.__returnTypeWrap = new TypeWrap(this.ownerClz, this.method.getReturnType(), this.method.getGenericReturnType());
        }
        return this.__returnTypeWrap;
    }

    public ParamWrap[] paramWraps() {
        if (this.__paramWraps == null) {
            this.__paramWraps = this.buildParamWraps();
        }
        return this.__paramWraps;
    }

    private ParamWrap[] buildParamWraps() {
        ParamWrap[] tmp = new ParamWrap[this.parameters.length];
        int len = this.parameters.length;
        for (int i = 0; i < len; ++i) {
            tmp[i] = new ParamWrap(this.parameters[i], this.method, this.ownerClz);
        }
        return tmp;
    }

    public MethodWrap ofHandler() {
        for (ParamWrap pw : this.getParamWraps()) {
            pw.spec();
        }
        return this;
    }

    private void doInterceptorAdd(Around a) {
        if (a != null) {
            this.doInterceptorAdd(new InterceptorEntity(a.index(), this.context.getBeanOrNew(a.value())));
        }
    }

    private void doInterceptorAdd(InterceptorEntity i) {
        if (i != null) {
            if (this.interceptorsIdx.contains(i.getReal())) {
                return;
            }
            this.interceptorsIdx.add(i.getReal());
            this.interceptors.add(i);
        }
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?> getOwnerClz() {
        return this.ownerClz;
    }

    @Override
    public Class<?> getDeclaringClz() {
        return this.declaringClz;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnTypeWrap().getType();
    }

    @Override
    @Nullable
    public ParameterizedType getGenericReturnType() {
        return this.returnTypeWrap().getGenericType();
    }

    @Override
    public ParamWrap[] getParamWraps() {
        return this.paramWraps();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.method.getAnnotation(type);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    @Override
    public List<InterceptorEntity> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public Object doIntercept(Invocation inv) throws Throwable {
        return this.invoke(inv.target(), inv.args());
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            throw Utils.throwableUnwrap(e2);
        }
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        Invocation inv = new Invocation(obj, args, this, this.interceptors);
        return inv.invoke();
    }
}

