/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.core.util.TmplUtil;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheTags;
import org.noear.solon.data.util.InvKeys;
import org.noear.solon.data.util.StringMutexLock;

public class CacheExecutorImp {
    public static final CacheExecutorImp global = new CacheExecutorImp();
    private final StringMutexLock SYNC_LOCK = new StringMutexLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cache(Cache anno, Invocation inv, SupplierEx executor) throws Throwable {
        if (anno == null) {
            return executor.get();
        }
        String key = anno.key();
        key = Utils.isEmpty(key) ? InvKeys.buildByInv(inv) : TmplUtil.parse(key, inv);
        Object result = null;
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        this.SYNC_LOCK.lock(key);
        try {
            Type type = inv.method().getGenericReturnType();
            if (type == null) {
                type = inv.method().getReturnType();
            }
            if ((result = cs.get(key, type)) == null && (result = executor.get()) != null) {
                cs.store(key, result, anno.seconds());
                if (Utils.isNotEmpty(anno.tags())) {
                    String tags = TmplUtil.parse(anno.tags(), inv, result);
                    CacheTags ct = new CacheTags(cs);
                    for (String tag : tags.split(",")) {
                        ct.add(tag, key, anno.seconds());
                    }
                }
            }
            Object var8_8 = result;
            return var8_8;
        }
        finally {
            this.SYNC_LOCK.unlock(key);
        }
    }

    public void cacheRemove(CacheRemove anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty(anno.keys())) {
            String keys = TmplUtil.parse(anno.keys(), inv, rstValue);
            for (String key : keys.split(",")) {
                cs.remove(key);
            }
        }
        if (Utils.isNotEmpty(anno.tags())) {
            String tags = TmplUtil.parse(anno.tags(), inv, rstValue);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.remove(tag);
            }
        }
    }

    public void cachePut(CachePut anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty(anno.key())) {
            String key = TmplUtil.parse(anno.key(), inv, rstValue);
            cs.store(key, rstValue, anno.seconds());
        }
        if (Utils.isNotEmpty(anno.tags())) {
            String tags = TmplUtil.parse(anno.tags(), inv, rstValue);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.update(tag, rstValue, anno.seconds());
            }
        }
    }
}

